/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNodeType;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.utils.Binary;

public class NodePathsSchemaScanOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final PartialPath partialPath;
    private final int level;
    private boolean isFinished;
    private final List<TSDataType> outputDataTypes;

    public NodePathsSchemaScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, PartialPath partialPath, int level) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.partialPath = partialPath;
        this.level = level;
        this.outputDataTypes = ColumnHeaderConstant.showChildPathsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(this.outputDataTypes);
        try {
            if (-1 == this.level) {
                Set<TSchemaNode> nodePaths = ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getChildNodePathInNextLevel(this.partialPath);
                nodePaths.forEach(node -> {
                    tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
                    tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(node.getNodeName()));
                    tsBlockBuilder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(node.getNodeType())));
                    tsBlockBuilder.declarePosition();
                });
            } else {
                Set<String> childNodes = ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getNodesListInGivenLevel(this.partialPath, this.level, false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet());
                childNodes.forEach(path -> {
                    tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
                    tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(path));
                    tsBlockBuilder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(MNodeType.UNIMPLEMENT.getNodeType())));
                    tsBlockBuilder.declarePosition();
                });
            }
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }
}

