/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk;

import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTreeFlushTaskManager {
    private static final Logger logger = LoggerFactory.getLogger(MTreeFlushTaskManager.class);
    private static final String MTREE_FLUSH_THREAD_POOL_NAME = "MTree-flush-task";
    private volatile ExecutorService flushTaskExecutor;

    private MTreeFlushTaskManager() {
    }

    public static MTreeFlushTaskManager getInstance() {
        return MTreeFlushTaskManagerHolder.INSTANCE;
    }

    public void init() {
        this.flushTaskExecutor = IoTDBThreadPoolFactory.newCachedThreadPool((String)MTREE_FLUSH_THREAD_POOL_NAME);
    }

    public void clear() {
        if (this.flushTaskExecutor != null) {
            this.flushTaskExecutor.shutdown();
            while (!this.flushTaskExecutor.isTerminated()) {
            }
            this.flushTaskExecutor = null;
        }
    }

    public void submit(Runnable task) {
        this.flushTaskExecutor.submit(() -> {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                logger.error("Something wrong happened during MTree flush.", throwable);
                throwable.printStackTrace();
                throw throwable;
            }
        });
    }

    private static class MTreeFlushTaskManagerHolder {
        private static final MTreeFlushTaskManager INSTANCE = new MTreeFlushTaskManager();

        private MTreeFlushTaskManagerHolder() {
        }
    }
}

