/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotCachedException;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MNodeUtils;
import org.apache.iotdb.db.metadata.mnode.estimator.IMNodeSizeEstimator;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.store.disk.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mtree.store.disk.MTreeFlushTaskManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.MTreeReleaseTaskManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.ICacheManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.cache.LRUCacheManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.IMemManager;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.MemManagerHolder;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedMTreeStore
implements IMTreeStore {
    private static final Logger logger = LoggerFactory.getLogger(CachedMTreeStore.class);
    private final IMemManager memManager = MemManagerHolder.getMemManagerInstance();
    private final ICacheManager cacheManager = new LRUCacheManager();
    private ISchemaFile file;
    private IMNode root;
    private final MTreeFlushTaskManager flushTaskManager = MTreeFlushTaskManager.getInstance();
    private int flushCount = 0;
    private volatile boolean hasFlushTask;
    private final MTreeReleaseTaskManager releaseTaskManager = MTreeReleaseTaskManager.getInstance();
    private volatile boolean hasReleaseTask;
    private int releaseCount = 0;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public CachedMTreeStore(PartialPath storageGroup, int schemaRegionId) throws MetadataException, IOException {
        this.file = SchemaFile.initSchemaFile(storageGroup.getFullPath(), schemaRegionId);
        this.root = this.file.init();
        this.cacheManager.initRootStatus(this.root);
        this.hasFlushTask = false;
        this.hasReleaseTask = false;
    }

    @Override
    public IMNode getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChild(IMNode parent, String name) throws MetadataException {
        this.readLock.lock();
        try {
            IMNode child = this.getChild(parent, name);
            if (child == null) {
                boolean bl = false;
                return bl;
            }
            this.unPin(child);
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode getChild(IMNode parent, String name) throws MetadataException {
        this.readLock.lock();
        try {
            IMNode node = parent.getChild(name);
            if (node == null) {
                node = this.loadChildFromDisk(parent, name);
            } else {
                try {
                    this.cacheManager.updateCacheStatusAfterMemoryRead(node);
                }
                catch (MNodeNotCachedException e) {
                    node = this.loadChildFromDisk(parent, name);
                }
            }
            if (node != null && node.isMeasurement()) {
                this.processAlias(parent.getAsEntityMNode(), node.getAsMeasurementMNode());
            }
            IMNode iMNode = node;
            return iMNode;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private IMNode loadChildFromDisk(IMNode parent, String name) throws MetadataException {
        IMNode node = null;
        if (!ICachedMNodeContainer.getCachedMNodeContainer(parent).isVolatile()) {
            try {
                node = this.file.getChildNode(parent, name);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
            if (node != null) {
                node = this.loadChildFromDiskToParent(parent, node);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMNode loadChildFromDiskToParent(IMNode parent, IMNode node) {
        IMNode iMNode = parent;
        synchronized (iMNode) {
            IMNode nodeAlreadyLoaded = parent.getChild(node.getName());
            if (nodeAlreadyLoaded != null) {
                try {
                    this.cacheManager.updateCacheStatusAfterMemoryRead(nodeAlreadyLoaded);
                    return nodeAlreadyLoaded;
                }
                catch (MNodeNotCachedException mNodeNotCachedException) {
                    // empty catch block
                }
            }
            node.setParent(parent);
            this.cacheManager.updateCacheStatusAfterDiskRead(node);
            this.ensureMemoryStatus();
            return node;
        }
    }

    private void processAlias(IEntityMNode parent, IMeasurementMNode node) {
        String alias = node.getAlias();
        if (alias != null) {
            parent.addAlias(alias, node);
        }
    }

    @Override
    public IMNodeIterator getChildrenIterator(IMNode parent) throws MetadataException {
        try {
            return new CachedMNodeIterator(parent);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode addChild(IMNode parent, String childName, IMNode child) {
        this.readLock.lock();
        try {
            child.setParent(parent);
            this.cacheManager.updateCacheStatusAfterAppend(child);
            this.ensureMemoryStatus();
            IMNode iMNode = parent.getChild(childName);
            return iMNode;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteChild(IMNode parent, String childName) throws MetadataException {
        this.writeLock.lock();
        try {
            IMNode deletedMNode = this.getChild(parent, childName);
            ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(parent);
            if (!container.isVolatile() && !container.hasChildInNewChildBuffer(childName)) {
                try {
                    this.file.delete(deletedMNode);
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
            parent.deleteChild(childName);
            this.cacheManager.remove(deletedMNode);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMNode(IMNode node) throws MetadataException {
        if (node.isStorageGroup()) {
            this.root = node;
            this.writeLock.lock();
            try {
                this.file.updateStorageGroupNode(node.getAsStorageGroupMNode());
            }
            catch (IOException e) {
                logger.error("IOException occurred during updating StorageGroupMNode {}", (Object)node.getFullPath());
                throw new MetadataException((Throwable)e);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        this.readLock.lock();
        try {
            this.cacheManager.updateCacheStatusAfterUpdate(node);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public IEntityMNode setToEntity(IMNode node) throws MetadataException {
        IEntityMNode result = MNodeUtils.setToEntity(node);
        if (result != node) {
            this.memManager.updatePinnedSize(IMNodeSizeEstimator.getEntityNodeBaseSize());
        }
        this.updateMNode(result);
        return result;
    }

    @Override
    public IMNode setToInternal(IEntityMNode entityMNode) throws MetadataException {
        IMNode result = MNodeUtils.setToInternal(entityMNode);
        if (result != entityMNode) {
            this.memManager.updatePinnedSize(-IMNodeSizeEstimator.getEntityNodeBaseSize());
        }
        this.updateMNode(result);
        return result;
    }

    @Override
    public void setAlias(IMeasurementMNode measurementMNode, String alias) throws MetadataException {
        String existingAlias = measurementMNode.getAlias();
        if (existingAlias == null && alias == null) {
            return;
        }
        measurementMNode.setAlias(alias);
        this.updateMNode(measurementMNode);
        if (existingAlias != null && alias != null) {
            this.memManager.updatePinnedSize(alias.length() - existingAlias.length());
        } else if (alias == null) {
            this.memManager.updatePinnedSize(-(IMNodeSizeEstimator.getAliasBaseSize() + existingAlias.length()));
        } else {
            this.memManager.updatePinnedSize(IMNodeSizeEstimator.getAliasBaseSize() + alias.length());
        }
    }

    @Override
    public void pin(IMNode node) throws MetadataException {
        this.readLock.lock();
        try {
            this.cacheManager.pinMNode(node);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void unPin(IMNode node) {
        this.readLock.lock();
        try {
            if (this.cacheManager.unPinMNode(node)) {
                this.ensureMemoryStatus();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void unPinPath(IMNode node) {
        while (!node.isStorageGroup()) {
            this.unPin(node);
            node = node.getParent();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheManager.clear(this.root);
            this.root = null;
            if (this.file != null) {
                try {
                    this.file.clear();
                    this.file.close();
                }
                catch (IOException | MetadataException e) {
                    logger.error(String.format("Error occurred during SchemaFile clear, %s", e.getMessage()));
                }
            }
            this.file = null;
            this.hasFlushTask = false;
            this.hasReleaseTask = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        this.writeLock.lock();
        try {
            this.flushVolatileNodes();
            boolean bl = this.file.createSnapshot(snapshotDir);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static CachedMTreeStore loadFromSnapshot(File snapshotDir, String storageGroup, int schemaRegionId) throws IOException, MetadataException {
        return new CachedMTreeStore(snapshotDir, storageGroup, schemaRegionId);
    }

    private CachedMTreeStore(File snapshotDir, String storageGroup, int schemaRegionId) throws IOException, MetadataException {
        this.file = SchemaFile.loadSnapshot(snapshotDir, storageGroup, schemaRegionId);
        this.root = this.file.init();
        this.cacheManager.initRootStatus(this.root);
        this.hasFlushTask = false;
        this.hasReleaseTask = false;
    }

    private void ensureMemoryStatus() {
        if (this.memManager.isExceedFlushThreshold() && !this.hasReleaseTask) {
            this.registerReleaseTask();
        }
    }

    private synchronized void registerReleaseTask() {
        if (this.hasReleaseTask) {
            return;
        }
        this.hasReleaseTask = true;
        this.releaseTaskManager.submit(this::tryExecuteMemoryRelease);
    }

    private void tryExecuteMemoryRelease() {
        this.readLock.lock();
        try {
            this.executeMemoryRelease();
            ++this.releaseCount;
            this.hasReleaseTask = false;
        }
        finally {
            this.readLock.unlock();
        }
        if (this.memManager.isExceedFlushThreshold() && !this.hasFlushTask) {
            this.registerFlushTask();
        }
    }

    private void executeMemoryRelease() {
        while (this.memManager.isExceedReleaseThreshold() && !this.memManager.isEmpty() && this.cacheManager.evict()) {
        }
    }

    private synchronized void registerFlushTask() {
        if (this.hasFlushTask) {
            return;
        }
        this.hasFlushTask = true;
        this.flushTaskManager.submit(this::flushVolatileNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushVolatileNodes() {
        this.writeLock.lock();
        try {
            List<IMNode> nodesToPersist = this.cacheManager.collectVolatileMNodes();
            for (IMNode volatileNode : nodesToPersist) {
                try {
                    this.file.writeMNode(volatileNode);
                }
                catch (IOException | MetadataException e) {
                    logger.error("Error occurred during MTree flush, current node is {}", (Object)volatileNode.getFullPath(), (Object)e);
                    this.writeLock.unlock();
                    return;
                }
                this.cacheManager.updateCacheStatusAfterPersist(volatileNode);
            }
            this.executeMemoryRelease();
            this.hasFlushTask = false;
            ++this.flushCount;
        }
        catch (Throwable e) {
            logger.error("Error occurred during MTree flush, current SchemaRegion is {}", (Object)this.root.getFullPath(), (Object)e);
            e.printStackTrace();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private class CachedMNodeIterator
    implements IMNodeIterator {
        IMNode parent;
        Iterator<IMNode> iterator;
        Iterator<IMNode> bufferIterator;
        boolean isIteratingDisk;
        IMNode nextNode;

        CachedMNodeIterator(IMNode parent) throws MetadataException, IOException {
            CachedMTreeStore.this.readLock.lock();
            try {
                this.parent = parent;
                ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(parent);
                this.bufferIterator = container.getChildrenBufferIterator();
                if (!container.isVolatile()) {
                    this.iterator = CachedMTreeStore.this.file.getChildren(parent);
                    this.isIteratingDisk = true;
                } else {
                    this.iterator = this.bufferIterator;
                    this.isIteratingDisk = false;
                }
            }
            catch (Throwable e) {
                CachedMTreeStore.this.readLock.unlock();
                throw e;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextNode != null) {
                return true;
            }
            try {
                this.readNext();
            }
            catch (MetadataException e) {
                logger.error(String.format("Error occurred during readNext, %s", e.getMessage()));
                return false;
            }
            return this.nextNode != null;
        }

        @Override
        public IMNode next() {
            if (this.nextNode == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            IMNode result = this.nextNode;
            this.nextNode = null;
            return result;
        }

        private void readNext() throws MetadataException {
            IMNode node = null;
            if (this.isIteratingDisk) {
                ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(this.parent);
                if (this.iterator.hasNext()) {
                    node = this.iterator.next();
                    while (container.hasChildInBuffer(node.getName())) {
                        if (this.iterator.hasNext()) {
                            node = this.iterator.next();
                            continue;
                        }
                        node = null;
                        break;
                    }
                }
                if (node != null) {
                    IMNode nodeInMem = this.parent.getChild(node.getName());
                    if (nodeInMem != null) {
                        try {
                            CachedMTreeStore.this.cacheManager.updateCacheStatusAfterMemoryRead(nodeInMem);
                            node = nodeInMem;
                        }
                        catch (MNodeNotCachedException e) {
                            node = CachedMTreeStore.this.loadChildFromDiskToParent(this.parent, node);
                        }
                    } else {
                        node = CachedMTreeStore.this.loadChildFromDiskToParent(this.parent, node);
                    }
                    this.nextNode = node;
                    return;
                }
                this.startIteratingBuffer();
            }
            if (this.iterator.hasNext()) {
                node = this.iterator.next();
                CachedMTreeStore.this.cacheManager.updateCacheStatusAfterMemoryRead(node);
            }
            this.nextNode = node;
        }

        private void startIteratingBuffer() {
            this.iterator = this.bufferIterator;
            this.isIteratingDisk = false;
        }

        @Override
        public void close() {
            try {
                if (this.nextNode != null) {
                    CachedMTreeStore.this.unPin(this.nextNode);
                    this.nextNode = null;
                }
            }
            finally {
                CachedMTreeStore.this.readLock.unlock();
            }
        }
    }
}

