/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.engine.storagegroup.DataRegionInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfoMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;

public class TsFileProcessorInfo {
    private DataRegionInfo dataRegionInfo;
    private long memCost;

    public TsFileProcessorInfo(DataRegionInfo dataRegionInfo) {
        this.dataRegionInfo = dataRegionInfo;
        this.memCost = 0L;
        if (null != dataRegionInfo.getDataRegion()) {
            MetricService.getInstance().addMetricSet((IMetricSet)new TsFileProcessorInfoMetrics(dataRegionInfo.getDataRegion().getStorageGroupName(), this.memCost));
        }
    }

    public void addTSPMemCost(long cost) {
        this.memCost += cost;
        this.dataRegionInfo.addStorageGroupMemCost(cost);
    }

    public void releaseTSPMemCost(long cost) {
        this.dataRegionInfo.releaseStorageGroupMemCost(cost);
        this.memCost -= cost;
    }

    public void clear() {
        this.dataRegionInfo.releaseStorageGroupMemCost(this.memCost);
        this.memCost = 0L;
    }
}

