/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import io.airlift.slice.SizeOf;
import java.util.Arrays;
import java.util.Optional;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnEncoding;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class DoubleColumn
implements Column {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DoubleColumn.class).instanceSize();
    public static final int SIZE_IN_BYTES_PER_POSITION = 9;
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final double[] values;
    private final long retainedSizeInBytes;

    public DoubleColumn(int positionCount, Optional<boolean[]> valueIsNull, double[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    DoubleColumn(int arrayOffset, int positionCount, boolean[] valueIsNull, double[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((double[])values);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.DOUBLE;
    }

    @Override
    public ColumnEncoding getEncoding() {
        return ColumnEncoding.INT64_ARRAY;
    }

    @Override
    public double getDouble(int position) {
        return this.values[position + this.arrayOffset];
    }

    @Override
    public double[] getDoubles() {
        return this.values;
    }

    @Override
    public Object getObject(int position) {
        return this.getDouble(position);
    }

    @Override
    public TsPrimitiveType getTsPrimitiveType(int position) {
        return new TsPrimitiveType.TsDouble(this.getDouble(position));
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public boolean[] isNull() {
        if (this.valueIsNull == null) {
            boolean[] res = new boolean[this.positionCount];
            Arrays.fill(res, false);
            return res;
        }
        return this.valueIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new DoubleColumn(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new DoubleColumn(this.arrayOffset + fromIndex, this.positionCount - fromIndex, this.valueIsNull, this.values);
    }

    @Override
    public void reverse() {
        int j;
        int i = this.arrayOffset;
        for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
            double valueTmp = this.values[i];
            this.values[i] = this.values[j];
            this.values[j] = valueTmp;
        }
        if (this.valueIsNull != null) {
            i = this.arrayOffset;
            for (j = this.arrayOffset + this.positionCount - 1; i < j; ++i, --j) {
                boolean isNullTmp = this.valueIsNull[i];
                this.valueIsNull[i] = this.valueIsNull[j];
                this.valueIsNull[j] = isNullTmp;
            }
        }
    }
}

