/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.nio.Buffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.iot.thrift.TLogBatch;

public class PendingBatch {
    private final IoTConsensusConfig config;
    private long startIndex;
    private long endIndex;
    private final List<TLogBatch> batches = new ArrayList<TLogBatch>();
    private long serializedSize;
    private boolean synced;

    public PendingBatch(IoTConsensusConfig config) {
        this.config = config;
    }

    public void buildIndex() {
        if (!this.batches.isEmpty()) {
            this.startIndex = this.batches.get(0).getSearchIndex();
            this.endIndex = this.batches.get(this.batches.size() - 1).getSearchIndex();
        }
    }

    public void addTLogBatch(TLogBatch batch) {
        this.batches.add(batch);
        this.serializedSize += batch.getData() == null ? 0L : (long)batch.getData().stream().mapToInt(Buffer::capacity).sum();
    }

    public boolean canAccumulate() {
        return this.batches.size() < this.config.getReplication().getMaxRequestNumPerBatch() && this.serializedSize < (long)this.config.getReplication().getMaxSizePerBatch();
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public long getEndIndex() {
        return this.endIndex;
    }

    public List<TLogBatch> getBatches() {
        return this.batches;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }

    public boolean isEmpty() {
        return this.batches.isEmpty();
    }

    public long getSerializedSize() {
        return this.serializedSize;
    }

    public String toString() {
        return "PendingBatch{startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", size=" + this.batches.size() + ", serializedSize=" + this.serializedSize + '}';
    }
}

