/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.iot.IoTConsensusServerImpl;
import org.apache.iotdb.consensus.iot.client.AsyncIoTConsensusServiceClient;
import org.apache.iotdb.consensus.iot.client.DispatchLogHandler;
import org.apache.iotdb.consensus.iot.logdispatcher.IndexController;
import org.apache.iotdb.consensus.iot.logdispatcher.IoTConsensusMemoryManager;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcherThreadMetrics;
import org.apache.iotdb.consensus.iot.logdispatcher.PendingBatch;
import org.apache.iotdb.consensus.iot.logdispatcher.SyncStatus;
import org.apache.iotdb.consensus.iot.thrift.TLogBatch;
import org.apache.iotdb.consensus.iot.thrift.TSyncLogReq;
import org.apache.iotdb.consensus.iot.wal.ConsensusReqReader;
import org.apache.iotdb.consensus.iot.wal.GetConsensusReqReaderPlan;
import org.apache.iotdb.consensus.ratis.Utils;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(LogDispatcher.class);
    private static final long DEFAULT_INITIAL_SYNC_INDEX = 0L;
    private final IoTConsensusServerImpl impl;
    private final List<LogDispatcherThread> threads;
    private final String selfPeerId;
    private final IClientManager<TEndPoint, AsyncIoTConsensusServiceClient> clientManager;
    private ExecutorService executorService;
    private boolean stopped = false;

    public LogDispatcher(IoTConsensusServerImpl impl, IClientManager<TEndPoint, AsyncIoTConsensusServiceClient> clientManager) {
        this.impl = impl;
        this.selfPeerId = impl.getThisNode().getEndpoint().toString();
        this.clientManager = clientManager;
        this.threads = impl.getConfiguration().stream().filter(x -> !Objects.equals(x, impl.getThisNode())).map(x -> new LogDispatcherThread((Peer)x, impl.getConfig(), 0L)).collect(Collectors.toList());
        if (!this.threads.isEmpty()) {
            this.initLogSyncThreadPool();
        }
    }

    private void initLogSyncThreadPool() {
        this.executorService = IoTDBThreadPoolFactory.newCachedThreadPool((String)("LogDispatcher-" + this.impl.getThisNode().getGroupId()));
    }

    public synchronized void start() {
        if (!this.threads.isEmpty()) {
            this.threads.forEach(this.executorService::submit);
        }
    }

    public synchronized void stop() {
        if (!this.threads.isEmpty()) {
            this.threads.forEach(LogDispatcherThread::stop);
            this.executorService.shutdownNow();
            int timeout = 10;
            try {
                if (!this.executorService.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    logger.error("Unable to shutdown LogDispatcher service after {} seconds", (Object)timeout);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected Interruption when closing LogDispatcher service ");
            }
        }
        this.stopped = true;
    }

    public synchronized void addLogDispatcherThread(Peer peer, long initialSyncIndex) {
        if (this.stopped) {
            return;
        }
        LogDispatcherThread thread = new LogDispatcherThread(peer, this.impl.getConfig(), initialSyncIndex);
        this.threads.add(thread);
        if (this.executorService == null) {
            this.initLogSyncThreadPool();
        }
        this.executorService.submit(thread);
    }

    public synchronized void removeLogDispatcherThread(Peer peer) throws IOException {
        if (this.stopped) {
            return;
        }
        int threadIndex = -1;
        for (int i = 0; i < this.threads.size(); ++i) {
            if (!this.threads.get(i).peer.equals(peer)) continue;
            threadIndex = i;
            break;
        }
        if (threadIndex == -1) {
            return;
        }
        this.threads.get(threadIndex).stop();
        this.threads.get(threadIndex).cleanup();
        this.threads.remove(threadIndex);
    }

    public synchronized OptionalLong getMinSyncIndex() {
        return this.threads.stream().mapToLong(LogDispatcherThread::getCurrentSyncIndex).min();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(IndexedConsensusRequest request) {
        LogDispatcher logDispatcher = this;
        synchronized (logDispatcher) {
            this.threads.forEach(thread -> {
                logger.debug("{}->{}: Push a log to the queue, where the queue length is {}", new Object[]{this.impl.getThisNode().getGroupId(), thread.getPeer().getEndpoint().getIp(), thread.getPendingRequestSize()});
                if (!thread.offer(request)) {
                    logger.debug("{}: Log queue of {} is full, ignore the log to this node, searchIndex: {}", new Object[]{this.impl.getThisNode().getGroupId(), thread.getPeer(), request.getSearchIndex()});
                }
            });
        }
    }

    public class LogDispatcherThread
    implements Runnable {
        private static final long PENDING_REQUEST_TAKING_TIME_OUT_IN_SEC = 10L;
        private static final long START_INDEX = 1L;
        private final IoTConsensusConfig config;
        private final Peer peer;
        private final IndexController controller;
        private final SyncStatus syncStatus;
        private final BlockingQueue<IndexedConsensusRequest> pendingRequest;
        private final List<IndexedConsensusRequest> bufferedRequest = new LinkedList<IndexedConsensusRequest>();
        private final ConsensusReqReader reader = (ConsensusReqReader)((Object)LogDispatcher.access$100(LogDispatcher.this).getStateMachine().read(new GetConsensusReqReaderPlan()));
        private final IoTConsensusMemoryManager iotConsensusMemoryManager = IoTConsensusMemoryManager.getInstance();
        private volatile boolean stopped = false;
        private final ConsensusReqReader.ReqIterator walEntryIterator;
        private final LogDispatcherThreadMetrics metrics;

        public LogDispatcherThread(Peer peer, IoTConsensusConfig config, long initialSyncIndex) {
            this.peer = peer;
            this.config = config;
            this.pendingRequest = new LinkedBlockingQueue<IndexedConsensusRequest>();
            this.controller = new IndexController(LogDispatcher.this.impl.getStorageDir(), Utils.fromTEndPointToString(peer.getEndpoint()), initialSyncIndex, config.getReplication().getCheckpointGap());
            this.syncStatus = new SyncStatus(this.controller, config);
            this.walEntryIterator = this.reader.getReqIterator(1L);
            this.metrics = new LogDispatcherThreadMetrics(this);
        }

        public IndexController getController() {
            return this.controller;
        }

        public long getCurrentSyncIndex() {
            return this.controller.getCurrentIndex();
        }

        public Peer getPeer() {
            return this.peer;
        }

        public IoTConsensusConfig getConfig() {
            return this.config;
        }

        public int getPendingRequestSize() {
            return this.pendingRequest.size();
        }

        public int getBufferRequestSize() {
            return this.bufferedRequest.size();
        }

        public boolean offer(IndexedConsensusRequest indexedConsensusRequest) {
            boolean success;
            if (!this.iotConsensusMemoryManager.reserve(indexedConsensusRequest.getSerializedSize(), true)) {
                return false;
            }
            try {
                success = this.pendingRequest.offer(indexedConsensusRequest);
            }
            catch (Throwable t) {
                this.iotConsensusMemoryManager.free(indexedConsensusRequest.getSerializedSize());
                throw t;
            }
            if (!success) {
                this.iotConsensusMemoryManager.free(indexedConsensusRequest.getSerializedSize());
            }
            return success;
        }

        private void releaseReservedMemory(IndexedConsensusRequest indexedConsensusRequest) {
            this.iotConsensusMemoryManager.free(indexedConsensusRequest.getSerializedSize());
        }

        public void stop() {
            this.stopped = true;
            long requestSize = 0L;
            for (IndexedConsensusRequest indexedConsensusRequest : this.pendingRequest) {
                requestSize += indexedConsensusRequest.getSerializedSize();
            }
            this.pendingRequest.clear();
            this.iotConsensusMemoryManager.free(requestSize);
            requestSize = 0L;
            for (IndexedConsensusRequest indexedConsensusRequest : this.bufferedRequest) {
                requestSize += indexedConsensusRequest.getSerializedSize();
            }
            this.iotConsensusMemoryManager.free(requestSize);
            this.syncStatus.free();
            MetricService.getInstance().removeMetricSet((IMetricSet)this.metrics);
        }

        public void cleanup() throws IOException {
            this.controller.cleanupVersionFiles();
        }

        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void run() {
            logger.info("{}: Dispatcher for {} starts", (Object)LogDispatcher.this.impl.getThisNode(), (Object)this.peer);
            MetricService.getInstance().addMetricSet((IMetricSet)this.metrics);
            try {
                while (!Thread.interrupted() && !this.stopped) {
                    PendingBatch batch;
                    long startTime = System.currentTimeMillis();
                    while ((batch = this.getBatch()).isEmpty()) {
                        IndexedConsensusRequest request = this.pendingRequest.poll(10L, TimeUnit.SECONDS);
                        if (request == null) continue;
                        this.bufferedRequest.add(request);
                        if (this.pendingRequest.size() > this.config.getReplication().getMaxRequestNumPerBatch()) continue;
                        Thread.sleep(this.config.getReplication().getMaxWaitingTimeForAccumulatingBatchInMs());
                    }
                    MetricService.getInstance().getOrCreateHistogram(Metric.STAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.TYPE.toString(), "constructBatch", Tag.REGION.toString(), this.peer.getGroupId().toString()}).update((System.currentTimeMillis() - startTime) / (long)batch.getBatches().size());
                    this.syncStatus.addNextBatch(batch);
                    this.sendBatchAsync(batch, new DispatchLogHandler(this, batch));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error("Unexpected error in logDispatcher for peer {}", (Object)this.peer, (Object)e);
            }
            logger.info("{}: Dispatcher for {} exits", (Object)LogDispatcher.this.impl.getThisNode(), (Object)this.peer);
        }

        public void updateSafelyDeletedSearchIndex() {
            long currentSafelyDeletedSearchIndex = LogDispatcher.this.impl.getCurrentSafelyDeletedSearchIndex();
            this.reader.setSafelyDeletedSearchIndex(currentSafelyDeletedSearchIndex);
            if (LogDispatcher.this.impl.unblockWrite()) {
                LogDispatcher.this.impl.signal();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PendingBatch getBatch() {
            IndexedConsensusRequest request;
            long maxIndex;
            long startIndex = this.syncStatus.getNextSendingIndex();
            AtomicLong atomicLong = LogDispatcher.this.impl.getIndexObject();
            synchronized (atomicLong) {
                maxIndex = LogDispatcher.this.impl.getIndex() + 1L;
                logger.debug("{}: startIndex: {}, maxIndex: {}, pendingRequest size: {}, bufferedRequest size: {}", new Object[]{LogDispatcher.this.impl.getThisNode().getGroupId(), startIndex, maxIndex, this.getPendingRequestSize(), this.bufferedRequest.size()});
                this.pendingRequest.drainTo(this.bufferedRequest, this.config.getReplication().getMaxRequestNumPerBatch() - this.bufferedRequest.size());
            }
            Iterator<IndexedConsensusRequest> iterator = this.bufferedRequest.iterator();
            while (iterator.hasNext() && (request = iterator.next()).getSearchIndex() < startIndex) {
                iterator.remove();
                this.releaseReservedMemory(request);
            }
            PendingBatch batches = new PendingBatch(this.config);
            if (this.bufferedRequest.isEmpty()) {
                this.constructBatchFromWAL(startIndex, maxIndex, batches);
                batches.buildIndex();
                logger.debug("{} : accumulated a {} from wal when empty", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batches);
            } else {
                iterator = this.bufferedRequest.iterator();
                IndexedConsensusRequest prev = iterator.next();
                if (startIndex != prev.getSearchIndex()) {
                    this.constructBatchFromWAL(startIndex, prev.getSearchIndex(), batches);
                    if (!batches.canAccumulate()) {
                        batches.buildIndex();
                        logger.debug("{} : accumulated a {} from wal", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batches);
                        return batches;
                    }
                }
                this.constructBatchIndexedFromConsensusRequest(prev, batches);
                iterator.remove();
                this.releaseReservedMemory(prev);
                if (!batches.canAccumulate()) {
                    batches.buildIndex();
                    logger.debug("{} : accumulated a {} from queue", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batches);
                    return batches;
                }
                while (iterator.hasNext() && batches.canAccumulate()) {
                    IndexedConsensusRequest current = iterator.next();
                    if (current.getSearchIndex() != prev.getSearchIndex() + 1L) {
                        this.constructBatchFromWAL(prev.getSearchIndex() + 1L, current.getSearchIndex(), batches);
                        if (!batches.canAccumulate()) {
                            batches.buildIndex();
                            logger.debug("gap {} : accumulated a {} from queue and wal when gap", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batches);
                            return batches;
                        }
                    }
                    this.constructBatchIndexedFromConsensusRequest(current, batches);
                    prev = current;
                    iterator.remove();
                    this.releaseReservedMemory(current);
                }
                batches.buildIndex();
                logger.debug("{} : accumulated a {} from queue and wal", (Object)LogDispatcher.this.impl.getThisNode().getGroupId(), (Object)batches);
            }
            return batches;
        }

        public void sendBatchAsync(PendingBatch batch, DispatchLogHandler handler) {
            try {
                AsyncIoTConsensusServiceClient client = (AsyncIoTConsensusServiceClient)((Object)LogDispatcher.this.clientManager.borrowClient((Object)this.peer.getEndpoint()));
                TSyncLogReq req = new TSyncLogReq(LogDispatcher.this.selfPeerId, this.peer.getGroupId().convertToTConsensusGroupId(), batch.getBatches());
                logger.debug("Send Batch[startIndex:{}, endIndex:{}] to ConsensusGroup:{}", new Object[]{batch.getStartIndex(), batch.getEndIndex(), this.peer.getGroupId().convertToTConsensusGroupId()});
                client.syncLog(req, handler);
            }
            catch (IOException | TException e) {
                logger.error("Can not sync logs to peer {} because", (Object)this.peer, (Object)e);
                handler.onError((Exception)e);
            }
        }

        public SyncStatus getSyncStatus() {
            return this.syncStatus;
        }

        private void constructBatchFromWAL(long currentIndex, long maxIndex, PendingBatch logBatches) {
            logger.debug(String.format("DataRegion[%s]->%s: currentIndex: %d, maxIndex: %d", this.peer.getGroupId().getId(), this.peer.getEndpoint().getIp(), currentIndex, maxIndex));
            long targetIndex = currentIndex;
            this.walEntryIterator.skipTo(targetIndex);
            while (targetIndex < maxIndex && logBatches.canAccumulate()) {
                logger.debug("construct from WAL for one Entry, index : {}", (Object)targetIndex);
                try {
                    this.walEntryIterator.waitForNextReady();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("wait for next WAL entry is interrupted");
                }
                IndexedConsensusRequest data = this.walEntryIterator.next();
                if (data.getSearchIndex() < targetIndex) {
                    logger.warn("search for one Entry which index is {}, but find a smaller one, index : {}", (Object)targetIndex, (Object)data.getSearchIndex());
                    continue;
                }
                if (data.getSearchIndex() > targetIndex) {
                    logger.warn("search for one Entry which index is {}, but find a larger one, index : {}", (Object)targetIndex, (Object)data.getSearchIndex());
                    if (data.getSearchIndex() >= maxIndex) break;
                }
                targetIndex = data.getSearchIndex() + 1L;
                logBatches.addTLogBatch(new TLogBatch(data.getSerializedRequests(), data.getSearchIndex(), true));
            }
        }

        private void constructBatchIndexedFromConsensusRequest(IndexedConsensusRequest request, PendingBatch logBatches) {
            logBatches.addTLogBatch(new TLogBatch(request.getSerializedRequests(), request.getSearchIndex(), false));
        }
    }
}

