/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeReporter.class);
    private final List<Reporter> reporters = new ArrayList<Reporter>();

    public void startAll() {
        for (Reporter reporter : this.reporters) {
            if (reporter.start()) continue;
            LOGGER.warn("Failed to start {} reporter.", (Object)reporter.getReporterType());
        }
    }

    public boolean start(ReporterType reporterType) {
        for (Reporter reporter : this.reporters) {
            if (reporter.getReporterType() != reporterType) continue;
            return reporter.start();
        }
        LOGGER.error("Failed to start {} reporter because not find.", (Object)reporterType);
        return false;
    }

    public void stopAll() {
        for (Reporter reporter : this.reporters) {
            if (reporter.stop()) continue;
            LOGGER.error("Failed to stop {} reporter.", (Object)reporter.getReporterType());
        }
    }

    public boolean stop(ReporterType reporterType) {
        for (Reporter reporter : this.reporters) {
            if (reporter.getReporterType() != reporterType) continue;
            return reporter.stop();
        }
        LOGGER.error("Failed to stop {} reporter because not find.", (Object)reporterType.name());
        return false;
    }

    public void addReporter(Reporter reporter) {
        for (Reporter originReporter : this.reporters) {
            if (originReporter.getReporterType() != reporter.getReporterType()) continue;
            LOGGER.warn("Failed to load {} reporter because already existed", (Object)reporter.getReporterType());
            return;
        }
        this.reporters.add(reporter);
    }

    public void clearReporter() {
        this.reporters.clear();
    }
}

