/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandalonePartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandaloneSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.reporter.iotdb.InternalIoTDBReporter;
import org.apache.iotdb.metrics.utils.InternalReporterType;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBInternalReporter
extends InternalIoTDBReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBInternalReporter.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private final SessionInfo SESSION_INFO;
    private final IPartitionFetcher PARTITION_FETCHER;
    private final ISchemaFetcher SCHEMA_FETCHER;
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    public IoTDBInternalReporter() {
        if (config.isClusterMode()) {
            this.PARTITION_FETCHER = ClusterPartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = ClusterSchemaFetcher.getInstance();
        } else {
            this.PARTITION_FETCHER = StandalonePartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = StandaloneSchemaFetcher.getInstance();
        }
        this.SESSION_INFO = new SessionInfo(0L, "root", ZoneId.systemDefault().getId());
    }

    public InternalReporterType getType() {
        return InternalReporterType.IOTDB;
    }

    public boolean start() {
        if (this.currentServiceFuture == null) {
            this.currentServiceFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.service, () -> this.writeMetricToIoTDB(this.autoGauges), (long)1L, (long)MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), (TimeUnit)TimeUnit.SECONDS);
        }
        return true;
    }

    public boolean stop() {
        if (this.currentServiceFuture != null) {
            this.currentServiceFuture.cancel(true);
            this.currentServiceFuture = null;
        }
        this.clear();
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.IOTDB;
    }

    protected void writeMetricToIoTDB(Map<String, Object> valueMap, String prefix, long time) {
        try {
            TSInsertRecordReq request = new TSInsertRecordReq();
            ArrayList<String> measurements = new ArrayList<String>();
            ArrayList<TSDataType> types = new ArrayList<TSDataType>();
            ArrayList<Object> values = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                String measurement = entry.getKey();
                Object value = entry.getValue();
                measurements.add(measurement);
                types.add(this.inferType(value));
                values.add(value);
            }
            ByteBuffer buffer = SessionUtils.getValueBuffer(types, values);
            request.setPrefixPath(prefix);
            request.setTimestamp(time);
            request.setMeasurements(measurements);
            request.setValues(buffer);
            request.setIsAligned(false);
            Statement s = StatementGenerator.createStatement(request);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(s, queryId, this.SESSION_INFO, "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            if (result.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.error("Failed to update the value of metric with status {}", (Object)result.status);
            }
        }
        catch (IoTDBConnectionException e1) {
            LOGGER.error("Failed to update the value of metric because of unknown type");
        }
        catch (IllegalPathException | QueryProcessException e2) {
            LOGGER.error("Failed to update the value of metric because of internal error");
        }
    }

    protected void writeMetricsToIoTDB(Map<String, Map<String, Object>> valueMap, long time) {
        for (Map.Entry<String, Map<String, Object>> value : valueMap.entrySet()) {
            this.writeMetricToIoTDB(value.getValue(), value.getKey(), time);
        }
    }
}

