/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.engine.upgrade.UpgradeTask;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeSevice
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeSevice.class);
    private ExecutorService upgradeThreadPool;
    private static final AtomicInteger cntUpgradeFileNum = new AtomicInteger();

    private UpgradeSevice() {
    }

    public static UpgradeSevice getINSTANCE() {
        return InstanceHolder.INSTANCE;
    }

    public void start() {
        int updateThreadNum = IoTDBDescriptor.getInstance().getConfig().getUpgradeThreadCount();
        if (updateThreadNum <= 0) {
            updateThreadNum = 1;
        }
        this.upgradeThreadPool = IoTDBThreadPoolFactory.newFixedThreadPool((int)updateThreadNum, (String)"UpgradeThread");
        UpgradeLog.createUpgradeLog();
        UpgradeSevice.countUpgradeFiles();
        if (cntUpgradeFileNum.get() == 0) {
            this.stop();
            return;
        }
        UpgradeSevice.upgradeAll();
    }

    public void stop() {
        UpgradeLog.closeLogWriter();
        UpgradeUtils.clearUpgradeRecoverMap();
        if (this.upgradeThreadPool != null) {
            this.upgradeThreadPool.shutdownNow();
            logger.info("Waiting for upgrade task pool to shut down");
            this.upgradeThreadPool = null;
            logger.info("Upgrade service stopped");
        }
    }

    public ServiceType getID() {
        return ServiceType.UPGRADE_SERVICE;
    }

    public static AtomicInteger getTotalUpgradeFileNum() {
        return cntUpgradeFileNum;
    }

    public void submitUpgradeTask(UpgradeTask upgradeTask) {
        this.upgradeThreadPool.submit((Runnable)((Object)upgradeTask));
    }

    private static void countUpgradeFiles() {
    }

    private static void upgradeAll() {
    }

    public static class InstanceHolder {
        private static final UpgradeSevice INSTANCE = new UpgradeSevice();

        private InstanceHolder() {
        }
    }
}

