/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.ServerCommandLine;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.service.DataNode;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeServerCommandLine
extends ServerCommandLine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeServerCommandLine.class);
    public static final String MODE_START = "-s";
    public static final String MODE_REMOVE = "-r";
    private static final String USAGE = "Usage: <-s|-r> [-D{} <configure folder>] \n-s: start the node to the cluster\n-r: remove the node out of the cluster\n";

    protected String getUsage() {
        return USAGE;
    }

    protected int run(String[] args) throws Exception {
        if (args.length < 1) {
            this.usage(null);
            return -1;
        }
        DataNode dataNode = DataNode.getInstance();
        String mode = args[0];
        LOGGER.info("Running mode {}", (Object)mode);
        try {
            dataNode.serverCheckAndInit(mode);
        }
        catch (IOException | ConfigurationException e) {
            LOGGER.error("Meet error when doing start checking", e);
            return -1;
        }
        if (!dataNode.initLocalEngines()) {
            LOGGER.error("Init local engines error, stop process!");
            return -1;
        }
        if (MODE_START.equals(mode)) {
            dataNode.doAddNode();
        } else if (MODE_REMOVE.equals(mode)) {
            this.doRemoveDataNode(args);
        } else {
            LOGGER.error("Unrecognized mode {}", (Object)mode);
        }
        return 0;
    }

    private void doRemoveDataNode(String[] args) throws BadNodeUrlException, TException, IoTDBException {
        if (args.length != 2) {
            LOGGER.info("Usage: <node-id>/<ip>:<rpc-port>");
            return;
        }
        LOGGER.info("Starting to remove DataNode from cluster, parameter: {}, {}", (Object)args[0], (Object)args[1]);
        ConfigNodeInfo.getInstance().loadConfigNodeList();
        List<TDataNodeLocation> dataNodeLocations = this.buildDataNodeLocations(args[1]);
        if (dataNodeLocations.isEmpty()) {
            throw new BadNodeUrlException("No DataNode to remove");
        }
        LOGGER.info("Start to remove datanode, removed datanode endpoints: {}", dataNodeLocations);
        TDataNodeRemoveReq removeReq = new TDataNodeRemoveReq(dataNodeLocations);
        try (ConfigNodeClient configNodeClient = new ConfigNodeClient();){
            TDataNodeRemoveResp removeResp = configNodeClient.removeDataNode(removeReq);
            LOGGER.info("Remove result {} ", (Object)removeResp.toString());
            if (removeResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBException(removeResp.getStatus().toString(), removeResp.getStatus().getCode());
            }
            LOGGER.info("Submit remove-datanode request successfully, but the process may fail. more details are shown in the logs of confignode-leader and removed-datanode, and after the process of removing datanode ends successfully, you are supposed to delete directory and data of the removed-datanode manually");
        }
    }

    private List<TDataNodeLocation> buildDataNodeLocations(String args) {
        List<Object> dataNodeLocations = new ArrayList<TDataNodeLocation>();
        if (args == null || args.trim().isEmpty()) {
            return dataNodeLocations;
        }
        if (args.split(",").length > 1) {
            LOGGER.info("Incorrect input format, usage: <id>/<ip>:<rpc-port>");
            return dataNodeLocations;
        }
        try {
            List endPoints = NodeUrlUtils.parseTEndPointUrls((String)args);
            try (ConfigNodeClient client = new ConfigNodeClient();){
                dataNodeLocations = client.getDataNodeConfiguration(-1).getDataNodeConfigurationMap().values().stream().map(TDataNodeConfiguration::getLocation).filter(location -> endPoints.contains(location.getClientRpcEndPoint())).collect(Collectors.toList());
            }
            catch (TException e) {
                LOGGER.error("Get data node locations failed", (Throwable)e);
            }
        }
        catch (BadNodeUrlException e) {
            try (ConfigNodeClient client = new ConfigNodeClient();){
                for (String id : args.split(",")) {
                    if (!StringUtils.isNumeric((CharSequence)id)) {
                        LOGGER.warn("Incorrect id format {}, skipped...", (Object)id);
                        continue;
                    }
                    List nodeLocationResult = client.getDataNodeConfiguration(Integer.parseInt(id)).getDataNodeConfigurationMap().values().stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList());
                    if (nodeLocationResult.isEmpty()) {
                        LOGGER.warn("DataNode {} is not in cluster, skipped...", (Object)id);
                        continue;
                    }
                    if (dataNodeLocations.contains(nodeLocationResult.get(0))) continue;
                    dataNodeLocations.add((TDataNodeLocation)nodeLocationResult.get(0));
                }
            }
            catch (TException e1) {
                LOGGER.error("Get data node locations failed", (Throwable)e);
            }
        }
        return dataNodeLocations;
    }
}

