/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.dataset.groupby.GroupByTimeEngineDataSet;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByLevelDataSet
extends QueryDataSet {
    private static final Logger logger = LoggerFactory.getLogger(GroupByLevelDataSet.class);
    private List<RowRecord> records = new ArrayList<RowRecord>();
    private int index = 0;

    public GroupByLevelDataSet(GroupByTimePlan plan, GroupByTimeEngineDataSet dataSet) throws IOException {
        this.paths = new ArrayList<PartialPath>(plan.getDeduplicatedPaths());
        this.dataTypes = plan.getDeduplicatedDataTypes();
        if (logger.isDebugEnabled()) {
            logger.debug("paths " + this.paths + " level:" + Arrays.toString(plan.getLevels()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("only group by level, paths:" + plan.getPaths());
        }
        this.paths = new ArrayList();
        this.dataTypes = new ArrayList();
        while (dataSet != null && dataSet.hasNextWithoutConstraint()) {
            RowRecord rawRecord = dataSet.nextWithoutConstraint();
            RowRecord curRecord = new RowRecord(rawRecord.getTimestamp());
            Map<String, AggregateResult> groupPathResultMap = plan.groupAggResultByLevel(Arrays.asList(dataSet.getCurAggregateResults()));
            for (AggregateResult aggregateResult : groupPathResultMap.values()) {
                curRecord.addField(aggregateResult.getResult(), aggregateResult.getResultDataType());
            }
            this.records.add(curRecord);
            if (!this.paths.isEmpty()) continue;
            for (Map.Entry entry : groupPathResultMap.entrySet()) {
                String alias = plan.getGroupByLevelController().getAlias((String)entry.getKey());
                this.paths.add(new PartialPath(alias != null ? alias : (String)entry.getKey(), false));
                this.dataTypes.add(((AggregateResult)entry.getValue()).getResultDataType());
            }
        }
        this.columnNum = this.dataTypes.size();
    }

    public boolean hasNextWithoutConstraint() {
        return this.index < this.records.size();
    }

    public RowRecord nextWithoutConstraint() {
        return this.records.get(this.index++);
    }
}

