/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.qp.logical.crud.AggregationQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.GroupByFillQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.UDAFPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class UDAFQueryOperator
extends QueryOperator {
    private List<ResultColumn> innerResultColumnsCache;
    private AggregationQueryOperator innerAggregationQueryOperator;

    public UDAFQueryOperator(AggregationQueryOperator queryOperator) {
        super(queryOperator);
        this.innerAggregationQueryOperator = queryOperator;
    }

    @Override
    public void check() throws LogicalOperatorException {
        super.check();
        if (!this.isAlignByTime()) {
            throw new LogicalOperatorException("AGGREGATION doesn't support disable align clause.");
        }
        this.checkSelectComponent(this.selectComponent);
        if (this.isGroupByLevel()) {
            throw new LogicalOperatorException("UDF nesting aggregations in GROUP BY query does not support grouping by level now.");
        }
        if (this.innerAggregationQueryOperator instanceof GroupByFillQueryOperator) {
            throw new LogicalOperatorException("UDF nesting aggregations in GROUP BY query does not support FILL now.");
        }
    }

    private void checkSelectComponent(SelectComponent selectComponent) throws LogicalOperatorException {
        for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
            Expression expression = resultColumn.getExpression();
            this.checkEachExpression(expression);
        }
    }

    public List<ResultColumn> getInnerResultColumnsCache() {
        if (this.innerResultColumnsCache == null) {
            this.innerResultColumnsCache = new ArrayList<ResultColumn>();
            for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
                Expression expression = resultColumn.getExpression();
                this.addInnerResultColumn(expression);
            }
        }
        return this.innerResultColumnsCache;
    }

    private void addInnerResultColumn(Expression expression) {
        Iterator<Expression> it = expression.iterator();
        while (it.hasNext()) {
            Expression currentExp = it.next();
            if (!currentExp.isBuiltInAggregationFunctionExpression()) continue;
            this.innerResultColumnsCache.add(new ResultColumn(currentExp));
        }
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        QueryPlan physicalPlan;
        AggregationPlan innerAggregationPlan = this.initInnerAggregationPlan(generator);
        if (!this.isAlignByDevice()) {
            physicalPlan = super.generateRawDataQueryPlan(generator, new UDAFPlan(this.selectComponent.getZoneId()));
            UDAFPlan udafPlan = (UDAFPlan)physicalPlan;
            udafPlan.setInnerAggregationPlan(innerAggregationPlan);
            HashMap<Expression, Integer> expressionToInnerResultIndexMap = new HashMap<Expression, Integer>();
            HashMap<String, Integer> aggrIndexMap = new HashMap<String, Integer>();
            for (int i = 0; i < innerAggregationPlan.getDeduplicatedPaths().size(); ++i) {
                aggrIndexMap.put(innerAggregationPlan.getDeduplicatedAggregations().get(i) + "(" + innerAggregationPlan.getDeduplicatedPaths().get(i) + ")", i);
            }
            for (ResultColumn rc : this.getInnerResultColumnsCache()) {
                expressionToInnerResultIndexMap.put(rc.getExpression(), (Integer)aggrIndexMap.get(((FunctionExpression)rc.getExpression()).getExpressionStringInternal()));
            }
            udafPlan.setExpressionToInnerResultIndexMap(expressionToInnerResultIndexMap);
            udafPlan.constructUdfExecutors(this.selectComponent.getResultColumns());
        } else {
            physicalPlan = new AggregationPlan();
        }
        return physicalPlan;
    }

    private AggregationPlan initInnerAggregationPlan(PhysicalGenerator generator) throws QueryProcessException {
        SelectComponent copiedSelectComponent = new SelectComponent(this.getSelectComponent());
        copiedSelectComponent.setHasPlainAggregationFunction(true);
        copiedSelectComponent.setResultColumns(this.getInnerResultColumnsCache());
        this.innerAggregationQueryOperator.setSelectComponent(copiedSelectComponent);
        this.innerAggregationQueryOperator.setFromComponent(this.getFromComponent());
        this.innerAggregationQueryOperator.setWhereComponent(this.getWhereComponent());
        this.innerAggregationQueryOperator.setSpecialClauseComponent(this.getSpecialClauseComponent());
        this.innerAggregationQueryOperator.setProps(this.getProps());
        this.innerAggregationQueryOperator.setIndexType(this.getIndexType());
        this.innerAggregationQueryOperator.setEnableTracing(this.isEnableTracing());
        return (AggregationPlan)this.innerAggregationQueryOperator.generatePhysicalPlan(generator);
    }

    private void checkEachExpression(Expression expression) throws LogicalOperatorException {
        if (expression instanceof TimeSeriesOperand) {
            throw new LogicalOperatorException("Common queries and aggregated queries are not allowed to appear at the same time");
        }
        if (expression.isBuiltInAggregationFunctionExpression()) {
            if (expression.getExpressions().size() == 1 && expression.getExpressions().get(0) instanceof TimeSeriesOperand) {
                return;
            }
            throw new LogicalOperatorException("The argument of the aggregation function must be a time series.");
        }
        for (Expression childExp : expression.getExpressions()) {
            this.checkEachExpression(childExp);
        }
    }
}

