/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.handler;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.handler.AbstractQueryHandler;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.db.service.thrift.impl.NewInfluxDBServiceImpl;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.influxdb.dto.QueryResult;

public class NewQueryHandler
extends AbstractQueryHandler {
    public final InfluxFunctionValue updateByIoTDBFunc(String path, InfluxFunction function, long sessionid) {
        switch (function.getFunctionName()) {
            case "count": {
                String functionSql = StringUtils.generateFunctionSql(function.getFunctionName(), function.getParmaName(), path);
                TSExecuteStatementResp tsExecuteStatementResp = NewInfluxDBServiceImpl.executeStatement(functionSql, sessionid);
                List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(influxFunctionValue);
                }
                break;
            }
            case "mean": {
                String functionSqlCount = StringUtils.generateFunctionSql("count", function.getParmaName(), path);
                TSExecuteStatementResp tsExecuteStatementResp = NewInfluxDBServiceImpl.executeStatement(functionSqlCount, sessionid);
                List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(influxFunctionValue);
                }
                String functionSqlSum = StringUtils.generateFunctionSql("sum", function.getParmaName(), path);
                tsExecuteStatementResp = NewInfluxDBServiceImpl.executeStatement(functionSqlSum, sessionid);
                list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(null, influxFunctionValue);
                }
                break;
            }
            case "sum": {
                String functionSql = StringUtils.generateFunctionSql("sum", function.getParmaName(), path);
                TSExecuteStatementResp tsExecuteStatementResp = NewInfluxDBServiceImpl.executeStatement(functionSql, sessionid);
                List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(influxFunctionValue);
                }
                break;
            }
            case "first": 
            case "last": {
                String functionName;
                String functionSql;
                if (function.getFunctionName().equals("first")) {
                    functionSql = StringUtils.generateFunctionSql("first_value", function.getParmaName(), path);
                    functionName = "first_value";
                } else {
                    functionSql = StringUtils.generateFunctionSql("last_value", function.getParmaName(), path);
                    functionName = "last_value";
                }
                TSExecuteStatementResp tsExecuteStatementResp = NewInfluxDBServiceImpl.executeStatement(functionSql, sessionid);
                Map<String, Object> map = QueryResultUtils.getColumnNameAndValue(tsExecuteStatementResp);
                for (String colume : map.keySet()) {
                    Object o = map.get(colume);
                    String fullPath = colume.substring(functionName.length() + 1, colume.length() - 1);
                    String devicePath = StringUtils.getDeviceByPath(fullPath);
                    String specificSql = String.format("select %s from %s where %s=%s", function.getParmaName(), devicePath, fullPath, o);
                    TSExecuteStatementResp resp = NewInfluxDBServiceImpl.executeStatement(specificSql, sessionid);
                    List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(resp);
                    for (InfluxFunctionValue influxFunctionValue : list) {
                        function.updateValueIoTDBFunc(influxFunctionValue);
                    }
                }
                break;
            }
            case "max": 
            case "min": {
                String functionSql = function.getFunctionName().equals("max") ? StringUtils.generateFunctionSql("max_value", function.getParmaName(), path) : StringUtils.generateFunctionSql("min_value", function.getParmaName(), path);
                TSExecuteStatementResp tsExecuteStatementResp = NewInfluxDBServiceImpl.executeStatement(functionSql, sessionid);
                List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(influxFunctionValue);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + function.getFunctionName());
            }
        }
        return function.calculateByIoTDBFunc();
    }

    @Override
    public InfluxFunctionValue updateByIoTDBFunc(String database, String measurement, InfluxFunction function, long sessionid) {
        String path = "root." + database + "." + measurement;
        return this.updateByIoTDBFunc(path, function, sessionid);
    }

    @Override
    public QueryResult queryByConditions(String querySql, String database, String measurement, Map<String, Integer> tagOrders, Map<String, Integer> fieldOrders, long sessionId) {
        TSExecuteStatementResp executeStatementResp = NewInfluxDBServiceImpl.executeStatement(querySql, sessionId);
        return QueryResultUtils.iotdbResultConvertInfluxResult(executeStatementResp, database, measurement, fieldOrders);
    }
}

