/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LimitNode
extends SingleChildProcessNode {
    private final int limit;

    public LimitNode(PlanNodeId id, int limit) {
        super(id);
        this.limit = limit;
    }

    public LimitNode(PlanNodeId id, PlanNode child, int limit) {
        super(id, child);
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public PlanNode clone() {
        return new LimitNode(this.getPlanNodeId(), this.limit);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LIMIT.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.limit, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LIMIT.serialize(stream);
        ReadWriteIOUtils.write((int)this.limit, (OutputStream)stream);
    }

    public static LimitNode deserialize(ByteBuffer byteBuffer) {
        int limit = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LimitNode(planNodeId, limit);
    }

    public String toString() {
        return "LimitNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitNode that = (LimitNode)o;
        return this.limit == that.limit;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.limit);
    }
}

