/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.plan.planner.plan.PlanFragment;

public class SubPlan {
    private PlanFragment planFragment;
    private List<SubPlan> children;

    public SubPlan(PlanFragment planFragment) {
        this.planFragment = planFragment;
        this.children = new ArrayList<SubPlan>();
    }

    public void setChildren(List<SubPlan> children) {
        this.children = children;
    }

    public void addChild(SubPlan subPlan) {
        this.children.add(subPlan);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("SubPlan-%s. RootNodeId: %s\n", this.planFragment.getId(), this.planFragment.getPlanNodeTree().getPlanNodeId()));
        this.children.forEach(result::append);
        return result.toString();
    }

    public PlanFragment getPlanFragment() {
        return this.planFragment;
    }

    public List<SubPlan> getChildren() {
        return this.children;
    }

    public List<PlanFragment> getPlanFragmentList() {
        ArrayList<PlanFragment> result = new ArrayList<PlanFragment>();
        result.add(this.planFragment);
        this.children.forEach(child -> result.addAll(child.getPlanFragmentList()));
        return result;
    }
}

