/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.executor;

import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupInfo;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.CountStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowStorageGroupTask;
import org.apache.iotdb.db.mpp.plan.execution.config.metadata.ShowTTLTask;
import org.apache.iotdb.db.mpp.plan.execution.config.sys.sync.ShowPipeSinkTask;
import org.apache.iotdb.db.mpp.plan.execution.config.sys.sync.ShowPipeTask;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateContinuousQueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateFunctionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTriggerStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.GetRegionIdStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.GetSeriesSlotListStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.GetTimeSlotListStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDataNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.DeactivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.CreatePipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.DropPipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.DropPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeSinkStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.StartPipeStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.StopPipeStatement;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneConfigTaskExecutor
implements IConfigTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneConfigTaskExecutor.class);

    public static StandaloneConfigTaskExecutor getInstance() {
        return StandaloneConfigTaskExecutorHolder.INSTANCE;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setStorageGroup(SetStorageGroupStatement setStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            LocalConfigNode localConfigNode = LocalConfigNode.getInstance();
            localConfigNode.setStorageGroup(setStorageGroupStatement.getStorageGroupPath());
            if (setStorageGroupStatement.getTTL() != null) {
                localConfigNode.setTTL(setStorageGroupStatement.getStorageGroupPath(), setStorageGroupStatement.getTTL());
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            LOGGER.error("Failed to create database, caused by ", (Throwable)e);
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showStorageGroup(ShowStorageGroupStatement showStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        HashMap<String, TStorageGroupInfo> storageGroupInfoMap = new HashMap<String, TStorageGroupInfo>();
        try {
            LocalConfigNode localConfigNode = LocalConfigNode.getInstance();
            List<PartialPath> partialPaths = localConfigNode.getMatchedStorageGroups(showStorageGroupStatement.getPathPattern(), showStorageGroupStatement.isPrefixPath());
            for (PartialPath storageGroupPath : partialPaths) {
                IStorageGroupMNode storageGroupMNode = localConfigNode.getStorageGroupNodeByPath(storageGroupPath);
                String storageGroup = storageGroupMNode.getFullPath();
                TStorageGroupSchema storageGroupSchema = storageGroupMNode.getStorageGroupSchema();
                TStorageGroupInfo storageGroupInfo = new TStorageGroupInfo();
                storageGroupInfo.setName(storageGroup);
                storageGroupInfo.setTTL(storageGroupSchema.getTTL());
                storageGroupInfo.setSchemaReplicationFactor(storageGroupSchema.getSchemaReplicationFactor());
                storageGroupInfo.setDataReplicationFactor(storageGroupSchema.getDataReplicationFactor());
                storageGroupInfo.setTimePartitionInterval(storageGroupSchema.getTimePartitionInterval());
                storageGroupInfo.setSchemaRegionNum(1);
                storageGroupInfo.setDataRegionNum(1);
                storageGroupInfoMap.put(storageGroup, storageGroupInfo);
            }
            ShowStorageGroupTask.buildTSBlock(storageGroupInfoMap, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (MetadataException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> countStorageGroup(CountStorageGroupStatement countStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            int storageGroupNum = LocalConfigNode.getInstance().getStorageGroupNum(countStorageGroupStatement.getPathPattern(), countStorageGroupStatement.isPrefixPath());
            CountStorageGroupTask.buildTSBlock(storageGroupNum, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (MetadataException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteStorageGroup(DeleteStorageGroupStatement deleteStorageGroupStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            ArrayList<PartialPath> deletePathList = new ArrayList<PartialPath>();
            for (String path : deleteStorageGroupStatement.getPrefixPath()) {
                PartialPath prefixPath = new PartialPath(path);
                deletePathList.addAll(LocalConfigNode.getInstance().getMatchedStorageGroups(prefixPath, false));
            }
            if (deletePathList.isEmpty()) {
                future.setException((Throwable)new IoTDBException(String.format("Path %s does not exist", Arrays.toString(deleteStorageGroupStatement.getPrefixPath().toArray())), TSStatusCode.PATH_NOT_EXIST.getStatusCode()));
                return future;
            }
            LocalConfigNode.getInstance().deleteStorageGroups(deletePathList);
        }
        catch (MetadataException e) {
            future.setException((Throwable)e);
            return future;
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createFunction(CreateFunctionStatement createFunctionStatement) {
        SettableFuture future = SettableFuture.create();
        String udfName = createFunctionStatement.getUdfName();
        String className = createFunctionStatement.getClassName();
        try {
            UDFManagementService.getInstance().register(new UDFInformation(udfName, className));
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            String message = String.format("Failed to create function %s(%s), because %s.", udfName, className, e);
            LOGGER.error(message, (Throwable)e);
            future.setException((Throwable)new IoTDBException(message, TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropFunction(String udfName) {
        SettableFuture future = SettableFuture.create();
        try {
            UDFManagementService.getInstance().deregister(udfName, false);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            String message = String.format("Failed to drop function %s, because %s.", udfName, e.getMessage());
            LOGGER.error(message, (Throwable)e);
            future.setException((Throwable)new IoTDBException(message, TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showFunctions() {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show functions in standalone mode is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createTrigger(CreateTriggerStatement createTriggerStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            String message = String.format("Failed to create trigger %s, because %s.", createTriggerStatement.getTriggerName(), e.getMessage());
            LOGGER.error(message, (Throwable)e);
            future.setException((Throwable)new IoTDBException(message, TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropTrigger(String triggerName) {
        SettableFuture future = SettableFuture.create();
        try {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            String message = String.format("Failed to drop trigger %s, because %s.", triggerName, e.getMessage());
            LOGGER.error(message, (Throwable)e);
            future.setException((Throwable)new IoTDBException(message, TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showTriggers() {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show triggers in standalone mode is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setTTL(SetTTLStatement setTTLStatement, String taskName) {
        SettableFuture future = SettableFuture.create();
        try {
            LocalConfigNode.getInstance().setTTL(setTTLStatement.getStorageGroupPath(), setTTLStatement.getTTL());
        }
        catch (IOException | MetadataException e) {
            future.setException(e);
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> merge(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().executeMergeOperation();
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> flush(TFlushReq tFlushReq, boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().executeFlushOperation(tFlushReq);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> clearCache(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().executeClearCacheOperation();
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> loadConfiguration(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().executeLoadConfigurationOperation();
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSystemStatus(boolean onCluster, NodeStatus status) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().executeSetSystemStatus(status);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCluster(ShowClusterStatement showClusterStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show cluster in standalone mode is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showTTL(ShowTTLStatement showTTLStatement) {
        SettableFuture future = SettableFuture.create();
        List<PartialPath> storageGroupPaths = showTTLStatement.getPaths();
        HashMap<String, Long> storageGroupToTTL = new HashMap<String, Long>();
        try {
            Map<PartialPath, Long> allStorageGroupToTTL = LocalConfigNode.getInstance().getStorageGroupsTTL();
            if (showTTLStatement.isAll()) {
                allStorageGroupToTTL.forEach((key, value) -> storageGroupToTTL.put(key.getFullPath(), (Long)value));
            } else {
                for (PartialPath storageGroupPath : storageGroupPaths) {
                    List<PartialPath> matchedStorageGroupPaths = LocalConfigNode.getInstance().getMatchedStorageGroups(storageGroupPath, showTTLStatement.isPrefixPath());
                    for (PartialPath matchedStorageGroupPath : matchedStorageGroupPaths) {
                        storageGroupToTTL.put(matchedStorageGroupPath.getFullPath(), allStorageGroupToTTL.get(matchedStorageGroupPath));
                    }
                }
            }
        }
        catch (MetadataException e) {
            future.setException((Throwable)e);
        }
        ShowTTLTask.buildTSBlock(storageGroupToTTL, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showRegion(ShowRegionStatement showRegionStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show regions in standalone mode is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showDataNodes(ShowDataNodesStatement showDataNodesStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show datanodes in standalone mode is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showConfigNodes() {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show confignodes in standalone mode is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createSchemaTemplate(CreateSchemaTemplateStatement createSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing create schema template is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show schema template is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show nodes in schema template is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSchemaTemplate(SetSchemaTemplateStatement setSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing set schema template is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show path set template is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deactivateSchemaTemplate(String queryId, DeactivateTemplateStatement deactivateTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing deactivate schema template is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropSchemaTemplate(DropSchemaTemplateStatement dropSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing drop schema template is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> unsetSchemaTemplate(String queryId, UnsetSchemaTemplateStatement unsetSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing unset schema template is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createPipeSink(CreatePipeSinkStatement createPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().createPipeSink(createPipeSinkStatement);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipeSink(DropPipeSinkStatement dropPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().dropPipeSink(dropPipeSinkStatement.getPipeSinkName());
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPipeSink(ShowPipeSinkStatement showPipeSinkStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            List<PipeSink> pipeSinkList = LocalConfigNode.getInstance().showPipeSink(showPipeSinkStatement.getPipeSinkName());
            ShowPipeSinkTask.buildTSBlockByPipeSink(pipeSinkList, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (PipeSinkException e) {
            ShowPipeSinkTask.buildTSBlockByPipeSink(Collections.emptyList(), (SettableFuture<ConfigTaskResult>)future);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createPipe(CreatePipeStatement createPipeStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().createPipe(createPipeStatement);
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> startPipe(StartPipeStatement startPipeStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().startPipe(startPipeStatement.getPipeName());
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> stopPipe(StopPipeStatement stopPipeStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().stopPipe(stopPipeStatement.getPipeName());
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipe(DropPipeStatement dropPipeStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = LocalConfigNode.getInstance().dropPipe(dropPipeStatement.getPipeName());
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPipe(ShowPipeStatement showPipeStatement) {
        SettableFuture future = SettableFuture.create();
        TShowPipeResp showPipeResp = LocalConfigNode.getInstance().showPipe(showPipeStatement.getPipeName());
        ShowPipeTask.buildTSBlock(showPipeResp.getPipeInfoList(), (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteTimeSeries(String queryId, DeleteTimeSeriesStatement deleteTimeSeriesStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing delete timeseries is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> getRegionId(GetRegionIdStatement getRegionIdStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing getRegion is not supported in standalone mode", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> getSeriesSlotList(GetSeriesSlotListStatement getSeriesSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing getSeriesSlotList is not supported in standalone mode", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> getTimeSlotList(GetTimeSlotListStatement getTimeSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing getTimeSlotList is not supported in standalone mode", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createContinuousQuery(CreateContinuousQueryStatement createContinuousQueryStatement, String sql, String username) {
        SettableFuture future = SettableFuture.create();
        try {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            String message = String.format("Failed to create continuous query %s, because %s.", createContinuousQueryStatement.getCqId(), e.getMessage());
            LOGGER.error(message, (Throwable)e);
            future.setException((Throwable)new IoTDBException(message, TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropContinuousQuery(String cqId) {
        SettableFuture future = SettableFuture.create();
        try {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            String message = String.format("Failed to continuous query trigger %s, because %s.", cqId, e.getMessage());
            LOGGER.error(message, (Throwable)e);
            future.setException((Throwable)new IoTDBException(message, TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showContinuousQueries() {
        SettableFuture future = SettableFuture.create();
        future.setException((Throwable)new IoTDBException("Executing show continuous queries in standalone mode is not supported", TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()));
        return future;
    }

    private static final class StandaloneConfigTaskExecutorHolder {
        private static final StandaloneConfigTaskExecutor INSTANCE = new StandaloneConfigTaskExecutor();

        private StandaloneConfigTaskExecutorHolder() {
        }
    }
}

