/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;

public class SelectIntoUtils {
    public static PartialPath constructTargetPath(PartialPath sourcePath, PartialPath deviceTemplate, String measurementTemplate) {
        PartialPath targetDevice = SelectIntoUtils.constructTargetDevice(sourcePath.getDevicePath(), deviceTemplate);
        String targetMeasurement = SelectIntoUtils.constructTargetMeasurement(sourcePath, measurementTemplate);
        return targetDevice.concatNode(targetMeasurement);
    }

    public static PartialPath constructTargetDevice(PartialPath sourceDevice, PartialPath deviceTemplate) {
        String[] sourceNodes = sourceDevice.getNodes();
        String[] templateNodes = deviceTemplate.getNodes();
        ArrayList<String> targetNodes = new ArrayList<String>();
        for (int nodeIndex = 0; nodeIndex < templateNodes.length; ++nodeIndex) {
            String curNode = templateNodes[nodeIndex];
            if (curNode.equals("::")) {
                if (nodeIndex != templateNodes.length - 1) {
                    throw new SemanticException("select into: placeholder `::` can only be used at the end of the path.");
                }
                while (nodeIndex < sourceNodes.length) {
                    targetNodes.add(sourceNodes[nodeIndex]);
                    ++nodeIndex;
                }
                break;
            }
            String resNode = SelectIntoUtils.applyLevelPlaceholder(curNode, sourceNodes);
            targetNodes.add(resNode);
        }
        return new PartialPath(targetNodes.toArray(new String[0]));
    }

    public static String constructTargetMeasurement(PartialPath sourcePath, String measurementTemplate) {
        if (measurementTemplate.equals("::")) {
            return sourcePath.getMeasurement();
        }
        return SelectIntoUtils.applyLevelPlaceholder(measurementTemplate, sourcePath.getNodes());
    }

    private static String applyLevelPlaceholder(String templateNode, String[] sourceNodes) {
        String resNode = templateNode;
        Matcher matcher = IoTDBConstant.LEVELED_PATH_TEMPLATE_PATTERN.matcher(resNode);
        while (matcher.find()) {
            int index;
            String param = matcher.group();
            try {
                index = Integer.parseInt(param.substring(2, param.length() - 1).trim());
            }
            catch (NumberFormatException e) {
                throw new SemanticException("select into: the i of ${i} should be an integer.");
            }
            if (index < 1 || index >= sourceNodes.length) {
                throw new SemanticException("select into: the i of ${i} should be greater than 0 and equal to or less than the length of queried path prefix.");
            }
            resNode = matcher.replaceFirst(sourceNodes[index]);
            matcher = IoTDBConstant.LEVELED_PATH_TEMPLATE_PATTERN.matcher(resNode);
        }
        return resNode;
    }

    public static boolean checkIsAllRawSeriesQuery(List<Expression> expressions) {
        for (Expression expression : expressions) {
            if (expression instanceof TimeSeriesOperand) continue;
            return false;
        }
        return true;
    }
}

