/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.source;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.DataSourceOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesScanOperator
implements DataSourceOperator {
    private final OperatorContext operatorContext;
    private final SeriesScanUtil seriesScanUtil;
    private final PlanNodeId sourceId;
    private final TsBlockBuilder builder;
    private boolean finished = false;
    private final long maxReturnSize;

    public SeriesScanOperator(PlanNodeId sourceId, PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, OperatorContext context, Filter timeFilter, Filter valueFilter, boolean ascending) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.seriesScanUtil = new SeriesScanUtil(seriesPath, allSensors, dataType, context.getInstanceContext(), timeFilter, valueFilter, ascending);
        this.maxReturnSize = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        this.builder = new TsBlockBuilder(this.seriesScanUtil.getTsDataTypeList());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        TsBlock block = this.builder.build();
        this.builder.reset();
        return block;
    }

    @Override
    public boolean hasNext() {
        try {
            long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
            long start = System.nanoTime();
            while ((this.readPageData() || this.readChunkData() || this.readFileData()) && System.nanoTime() - start < maxRuntime && !this.builder.isFull()) {
            }
            this.finished = this.builder.isEmpty();
            return !this.finished;
        }
        catch (IOException e) {
            throw new RuntimeException("Error happened while scanning the file", e);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    private boolean readFileData() throws IOException {
        while (this.seriesScanUtil.hasNextFile()) {
            if (!this.readChunkData()) continue;
            return true;
        }
        return false;
    }

    private boolean readChunkData() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            TsBlock tsBlock = this.seriesScanUtil.nextPage();
            if (this.isEmpty(tsBlock)) continue;
            this.appendToBuilder(tsBlock);
            return true;
        }
        return false;
    }

    private void appendToBuilder(TsBlock tsBlock) {
        TimeColumnBuilder timeColumnBuilder = this.builder.getTimeColumnBuilder();
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        ColumnBuilder columnBuilder = this.builder.getColumnBuilder(0);
        Column column = tsBlock.getColumn(0);
        if (column.mayHaveNull()) {
            int size = tsBlock.getPositionCount();
            for (int i = 0; i < size; ++i) {
                timeColumnBuilder.writeLong(timeColumn.getLong(i));
                if (column.isNull(i)) {
                    columnBuilder.appendNull();
                } else {
                    columnBuilder.write(column, i);
                }
                this.builder.declarePosition();
            }
        } else {
            int size = tsBlock.getPositionCount();
            for (int i = 0; i < size; ++i) {
                timeColumnBuilder.writeLong(timeColumn.getLong(i));
                columnBuilder.write(column, i);
                this.builder.declarePosition();
            }
        }
    }

    private boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public void initQueryDataSource(QueryDataSource dataSource) {
        this.seriesScanUtil.initQueryDataSource(dataSource);
    }
}

