/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaTsBlockUtil;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.utils.Binary;

public class LevelTimeSeriesCountOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final PartialPath partialPath;
    private final boolean isPrefixPath;
    private final int level;
    private final String key;
    private final String value;
    private final boolean isContains;
    private List<TsBlock> tsBlockList;
    private int currentIndex = 0;
    private final List<TSDataType> outputDataTypes;

    public LevelTimeSeriesCountOperator(PlanNodeId sourceId, OperatorContext operatorContext, PartialPath partialPath, boolean isPrefixPath, int level, String key, String value, boolean isContains) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.partialPath = partialPath;
        this.isPrefixPath = isPrefixPath;
        this.level = level;
        this.key = key;
        this.value = value;
        this.isContains = isContains;
        this.outputDataTypes = ColumnHeaderConstant.countLevelTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        return this.tsBlockList.get(this.currentIndex - 1);
    }

    @Override
    public boolean hasNext() {
        if (this.tsBlockList == null) {
            this.createTsBlockList();
        }
        return this.currentIndex < this.tsBlockList.size();
    }

    public void createTsBlockList() {
        Map<PartialPath, Long> countMap;
        try {
            countMap = this.key != null && this.value != null ? ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getMeasurementCountGroupByLevel(this.partialPath, this.level, this.isPrefixPath, this.key, this.value, this.isContains) : ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getMeasurementCountGroupByLevel(this.partialPath, this.level, this.isPrefixPath);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.tsBlockList = SchemaTsBlockUtil.transferSchemaResultToTsBlockList(countMap.entrySet().iterator(), this.outputDataTypes, (entry, tsBlockBuilder) -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(((PartialPath)entry.getKey()).getFullPath()));
            tsBlockBuilder.getColumnBuilder(1).writeLong(((Long)entry.getValue()).longValue());
            tsBlockBuilder.declarePosition();
        });
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }
}

