/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.filter;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.mpp.common.filter.FilterTypes;
import org.apache.iotdb.db.mpp.common.filter.FunctionFilter;
import org.apache.iotdb.db.mpp.common.filter.QueryFilter;
import org.apache.iotdb.db.mpp.plan.constant.FilterConstant;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class LikeFilter
extends FunctionFilter {
    protected String value;

    public LikeFilter(FilterConstant.FilterType filterType, PartialPath path, String value) {
        super(filterType);
        this.singlePath = path;
        this.value = value;
        this.isLeaf = true;
        this.isSingle = true;
    }

    @Override
    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(Map<PartialPath, TSDataType> pathTSDataTypeHashMap) throws StatementAnalyzeException, MetadataException {
        TSDataType type = pathTSDataTypeHashMap.get(this.singlePath);
        if (type == null) {
            throw new MetadataException("given seriesPath:{" + this.singlePath.getFullPath() + "} don't exist in metadata");
        }
        if (type != TSDataType.TEXT) {
            throw new StatementAnalyzeException(type.toString(), "Only TEXT is supported in 'Like'");
        }
        if (this.value.startsWith("\"") && this.value.endsWith("\"")) {
            throw new StatementAnalyzeException(this.value, "Please use single quotation marks");
        }
        IUnaryExpression ret = Like.getUnaryExpression(this.singlePath, this.value.startsWith("'") && this.value.endsWith("'") ? this.value.substring(1, this.value.length() - 1) : this.value);
        return new Pair((Object)ret, (Object)this.singlePath.getFullPath());
    }

    @Override
    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new String[]{this.singlePath.getFullPath(), this.getFilterSymbol(), this.value, ", single\n"});
        return sc.toString();
    }

    @Override
    public LikeFilter copy() {
        LikeFilter ret = new LikeFilter(this.filterType, this.singlePath.clone(), this.value);
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        ret.pathSet = this.pathSet;
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LikeFilter that = (LikeFilter)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.singlePath, this.value);
    }

    @Override
    public String toString() {
        return "[" + this.singlePath.getFullPath() + this.getFilterSymbol() + this.value + "]";
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        FilterTypes.Like.serialize(byteBuffer);
        super.serializeWithoutType(byteBuffer);
        ReadWriteIOUtils.write((String)this.value, (ByteBuffer)byteBuffer);
    }

    public static LikeFilter deserialize(ByteBuffer byteBuffer) {
        QueryFilter queryFilter = QueryFilter.deserialize(byteBuffer);
        LikeFilter likeFilter = new LikeFilter(queryFilter.filterType, queryFilter.singlePath, ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        return likeFilter;
    }

    private static class Like {
        private Like() {
        }

        public static <T extends Comparable<T>> IUnaryExpression getUnaryExpression(PartialPath path, String value) {
            return new SingleSeriesExpression((Path)path, (Filter)ValueFilter.like((String)value));
        }

        public <T extends Comparable<T>> Filter getValueFilter(String value) {
            return ValueFilter.like((String)value);
        }
    }
}

