/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;

public class SumAccumulator
implements Accumulator {
    private TSDataType seriesDataType;
    private double sumValue = 0.0;
    private boolean initResult = false;

    public SumAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
    }

    @Override
    public int addInput(Column[] column, IWindow curWindow) {
        switch (this.seriesDataType) {
            case INT32: {
                return this.addIntInput(column, curWindow);
            }
            case INT64: {
                return this.addLongInput(column, curWindow);
            }
            case FLOAT: {
                return this.addFloatInput(column, curWindow);
            }
            case DOUBLE: {
                return this.addDoubleInput(column, curWindow);
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Sum should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.initResult = true;
        this.sumValue += partialResult[0].getDouble(0);
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        this.initResult = true;
        this.sumValue = statistics instanceof IntegerStatistics ? (this.sumValue += (double)statistics.getSumLongValue()) : (this.sumValue += statistics.getSumDoubleValue());
    }

    @Override
    public void setFinal(Column finalResult) {
        this.reset();
        if (finalResult.isNull(0)) {
            return;
        }
        this.sumValue = finalResult.getDouble(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Sum should be 1");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
        } else {
            columnBuilders[0].writeDouble(this.sumValue);
        }
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValue);
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.sumValue = 0.0;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.DOUBLE};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.DOUBLE;
    }

    private int addIntInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column[2].getInt(i);
        }
        return curPositionCount;
    }

    private int addLongInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column[2].getLong(i);
        }
        return curPositionCount;
    }

    private int addFloatInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column[2].getFloat(i);
        }
        return curPositionCount;
    }

    private int addDoubleInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.initResult = true;
            this.sumValue += column[2].getDouble(i);
        }
        return curPositionCount;
    }
}

