/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.IMemManager;

public class MemManagerNodeNumBasedImpl
implements IMemManager {
    private int capacity;
    private final AtomicInteger size = new AtomicInteger(0);
    private final AtomicInteger pinnedSize = new AtomicInteger(0);

    MemManagerNodeNumBasedImpl() {
    }

    @Override
    public void init() {
        this.capacity = IoTDBDescriptor.getInstance().getConfig().getCachedMNodeSizeInSchemaFileMode();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public boolean isExceedReleaseThreshold() {
        return (double)(this.size.get() + this.pinnedSize.get()) > (double)this.capacity * 0.6;
    }

    @Override
    public boolean isExceedFlushThreshold() {
        return this.size.get() + this.pinnedSize.get() > this.capacity;
    }

    @Override
    public void requestPinnedMemResource(IMNode node) {
        this.pinnedSize.getAndIncrement();
    }

    @Override
    public void upgradeMemResource(IMNode node) {
        this.pinnedSize.getAndIncrement();
        this.size.getAndDecrement();
    }

    @Override
    public void releasePinnedMemResource(IMNode node) {
        this.size.getAndIncrement();
        this.pinnedSize.getAndDecrement();
    }

    @Override
    public void releaseMemResource(IMNode node) {
        this.size.getAndDecrement();
    }

    @Override
    public void releaseMemResource(List<IMNode> evictedNodes) {
        this.size.getAndUpdate(value -> value -= evictedNodes.size());
    }

    @Override
    public void updatePinnedSize(int deltaSize) {
    }

    @Override
    public void clear() {
        this.size.getAndSet(0);
        this.pinnedSize.getAndSet(0);
    }

    @Override
    public long getPinnedSize() {
        return this.pinnedSize.get();
    }

    @Override
    public long getCachedSize() {
        return this.size.get();
    }
}

