/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.localconfignode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;

public class LocalSchemaPartitionTable {
    private AtomicInteger schemaRegionIdGenerator;
    private Map<PartialPath, List<SchemaRegionId>> table;

    private LocalSchemaPartitionTable() {
    }

    public static LocalSchemaPartitionTable getInstance() {
        return LocalSchemaPartitionTableHolder.INSTANCE;
    }

    public synchronized void init(Map<PartialPath, List<SchemaRegionId>> recoveredLocalSchemaRegionInfo) throws MetadataException {
        this.table = new ConcurrentHashMap<PartialPath, List<SchemaRegionId>>();
        this.schemaRegionIdGenerator = new AtomicInteger(0);
        for (PartialPath storageGroup : recoveredLocalSchemaRegionInfo.keySet()) {
            CopyOnWriteArrayList<SchemaRegionId> schemaRegionIdList = new CopyOnWriteArrayList<SchemaRegionId>();
            this.table.put(storageGroup, schemaRegionIdList);
            for (SchemaRegionId schemaRegionId : recoveredLocalSchemaRegionInfo.get(storageGroup)) {
                schemaRegionIdList.add(schemaRegionId);
                if (schemaRegionId.getId() < this.schemaRegionIdGenerator.get()) continue;
                this.schemaRegionIdGenerator.set(schemaRegionId.getId() + 1);
            }
        }
    }

    public synchronized void clear() {
        if (this.table != null) {
            this.table.clear();
            this.table = null;
        }
        if (this.schemaRegionIdGenerator != null) {
            this.schemaRegionIdGenerator = null;
        }
    }

    public SchemaRegionId getSchemaRegionId(PartialPath storageGroup, PartialPath path) {
        if (!this.table.containsKey(storageGroup)) {
            return null;
        }
        return this.calculateSchemaRegionId(storageGroup, path);
    }

    public List<SchemaRegionId> getInvolvedSchemaRegionIds(PartialPath storageGroup, PartialPath pathPattern, boolean isPrefixMatch) {
        ArrayList<SchemaRegionId> result = new ArrayList<SchemaRegionId>();
        if (this.table.containsKey(storageGroup)) {
            result.addAll((Collection<SchemaRegionId>)this.table.get(storageGroup));
        }
        return result;
    }

    public List<SchemaRegionId> getSchemaRegionIdsByStorageGroup(PartialPath storageGroup) {
        return new ArrayList<SchemaRegionId>((Collection)this.table.get(storageGroup));
    }

    public synchronized List<SchemaRegionId> setStorageGroup(PartialPath storageGroup) {
        if (this.table.containsKey(storageGroup)) {
            return this.table.get(storageGroup);
        }
        CopyOnWriteArrayList<SchemaRegionId> schemaRegionIdList = new CopyOnWriteArrayList<SchemaRegionId>();
        schemaRegionIdList.add(new SchemaRegionId(this.schemaRegionIdGenerator.getAndIncrement()));
        this.table.put(storageGroup, schemaRegionIdList);
        return schemaRegionIdList;
    }

    public synchronized List<SchemaRegionId> deleteStorageGroup(PartialPath storageGroup) {
        return this.table.remove(storageGroup);
    }

    private SchemaRegionId calculateSchemaRegionId(PartialPath storageGroup, PartialPath path) {
        return this.table.get(storageGroup).get(0);
    }

    private static class LocalSchemaPartitionTableHolder {
        private static final LocalSchemaPartitionTable INSTANCE = new LocalSchemaPartitionTable();

        private LocalSchemaPartitionTableHolder() {
        }
    }
}

