/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;

public final class AutoCloseableLock
implements AutoCloseable {
    private final Lock underlying;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Runnable preUnlock;

    public static AutoCloseableLock acquire(Lock lock) {
        return AutoCloseableLock.acquire(lock, null);
    }

    public static AutoCloseableLock acquire(Lock lock, Runnable preUnlock) {
        lock.lock();
        return new AutoCloseableLock(lock, preUnlock);
    }

    private AutoCloseableLock(Lock underlying, Runnable preUnlock) {
        this.underlying = underlying;
        this.preUnlock = preUnlock;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                if (this.preUnlock != null) {
                    this.preUnlock.run();
                }
            }
            finally {
                this.underlying.unlock();
            }
        }
    }
}

