/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.statemachine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.env.DataNodeRemoveHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.RegionTransitionState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMigrateProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, RegionTransitionState> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionMigrateProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private final Object regionMigrateLock = new Object();
    private TConsensusGroupId consensusGroupId;
    private TDataNodeLocation originalDataNode;
    private TDataNodeLocation destDataNode;
    private boolean migrateSuccess = true;
    private String migrateResult = "";

    public RegionMigrateProcedure() {
    }

    public RegionMigrateProcedure(TConsensusGroupId consensusGroupId, TDataNodeLocation originalDataNode, TDataNodeLocation destDataNode) {
        this.consensusGroupId = consensusGroupId;
        this.originalDataNode = originalDataNode;
        this.destDataNode = destDataNode;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RegionTransitionState state) {
        if (this.consensusGroupId == null) {
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        DataNodeRemoveHandler handler = env.getDataNodeRemoveHandler();
        try {
            switch (state) {
                case REGION_MIGRATE_PREPARE: {
                    this.setNextState(RegionTransitionState.CREATE_NEW_REGION_PEER);
                    break;
                }
                case CREATE_NEW_REGION_PEER: {
                    handler.createNewRegionPeer(this.consensusGroupId, this.destDataNode);
                    this.setNextState(RegionTransitionState.ADD_REGION_PEER);
                    break;
                }
                case ADD_REGION_PEER: {
                    TSStatus tsStatus = handler.addRegionPeer(this.destDataNode, this.consensusGroupId);
                    if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        throw new ProcedureException("ADD_REGION_PEER executed failed in DataNode");
                    }
                    this.waitForOneMigrationStepFinished(this.consensusGroupId, state);
                    this.setNextState(RegionTransitionState.CHANGE_REGION_LEADER);
                    break;
                }
                case CHANGE_REGION_LEADER: {
                    handler.changeRegionLeader(this.consensusGroupId, this.originalDataNode, this.destDataNode);
                    this.setNextState(RegionTransitionState.REMOVE_REGION_PEER);
                    break;
                }
                case REMOVE_REGION_PEER: {
                    TSStatus tsStatus = handler.removeRegionPeer(this.originalDataNode, this.destDataNode, this.consensusGroupId);
                    if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        throw new ProcedureException("REMOVE_REGION_PEER executed failed in DataNode");
                    }
                    this.waitForOneMigrationStepFinished(this.consensusGroupId, state);
                    this.setNextState(RegionTransitionState.DELETE_OLD_REGION_PEER);
                    break;
                }
                case DELETE_OLD_REGION_PEER: {
                    TSStatus tsStatus = handler.deleteOldRegionPeer(this.originalDataNode, this.consensusGroupId);
                    if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        this.waitForOneMigrationStepFinished(this.consensusGroupId, state);
                    }
                    this.setNextState(RegionTransitionState.UPDATE_REGION_LOCATION_CACHE);
                    break;
                }
                case UPDATE_REGION_LOCATION_CACHE: {
                    handler.updateRegionLocationCache(this.consensusGroupId, this.originalDataNode, this.destDataNode);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
        }
        catch (Exception e) {
            LOG.error("{}, Meets error in region migrate state, please do the rollback operation yourself manually according to the error message!!! error state: {}, migrateResult: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", state, this.migrateResult});
            if (this.isRollbackSupported(state)) {
                this.setFailure(new ProcedureException("Region migrate failed at state: " + (Object)((Object)state)));
            }
            LOG.error("{}, Failed state [{}] is not support rollback, originalDataNode: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", state, DataNodeRemoveHandler.getIdWithRpcEndpoint(this.originalDataNode)});
            if (this.getCycles() > 5) {
                this.setFailure(new ProcedureException("Procedure retried failed exceed 5 times, state stuck at " + (Object)((Object)state)));
            }
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RegionTransitionState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected boolean isRollbackSupported(RegionTransitionState state) {
        return false;
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            if (configNodeProcedureEnv.getRegionMigrateLock().tryLock(this)) {
                LOG.info("procedureId {} acquire lock.", (Object)this.getProcId());
                ProcedureLockState procedureLockState = ProcedureLockState.LOCK_ACQUIRED;
                return procedureLockState;
            }
            configNodeProcedureEnv.getRegionMigrateLock().waitProcedure(this);
            LOG.info("procedureId {} wait for lock.", (Object)this.getProcId());
            ProcedureLockState procedureLockState = ProcedureLockState.LOCK_EVENT_WAIT;
            return procedureLockState;
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            LOG.info("procedureId {} release lock.", (Object)this.getProcId());
            if (configNodeProcedureEnv.getRegionMigrateLock().releaseLock(this)) {
                configNodeProcedureEnv.getRegionMigrateLock().wakeWaitingProcedures(configNodeProcedureEnv.getScheduler());
            }
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected RegionTransitionState getState(int stateId) {
        return RegionTransitionState.values()[stateId];
    }

    @Override
    protected int getStateId(RegionTransitionState regionTransitionState) {
        return regionTransitionState.ordinal();
    }

    @Override
    protected RegionTransitionState getInitialState() {
        return RegionTransitionState.REGION_MIGRATE_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.REGION_MIGRATE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.originalDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.destDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.consensusGroupId, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.originalDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.destDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.consensusGroupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize RemoveConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof RegionMigrateProcedure) {
            RegionMigrateProcedure thatProc = (RegionMigrateProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.originalDataNode.equals(this.originalDataNode) && thatProc.destDataNode.equals(this.destDataNode) && thatProc.consensusGroupId.equals(this.consensusGroupId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus waitForOneMigrationStepFinished(TConsensusGroupId consensusGroupId, RegionTransitionState state) throws Exception {
        LOG.info("{}, Wait for state {} finished, regionId: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", state, consensusGroupId});
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        Object object = this.regionMigrateLock;
        synchronized (object) {
            try {
                this.regionMigrateLock.wait();
                if (!this.migrateSuccess) {
                    throw new ProcedureException(String.format("Region migrate failed, regionId: %s", consensusGroupId));
                }
            }
            catch (InterruptedException e) {
                LOG.error("{}, region migrate {} interrupt", new Object[]{"[REMOVE_DATANODE_PROCESS]", consensusGroupId, e});
                Thread.currentThread().interrupt();
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage("wait region migrate interrupt," + e.getMessage());
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTheRegionMigrateFinished(TRegionMigrateResultReportReq req) {
        LOG.info("{}, ConfigNode received region migrate result reported by DataNode: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)req);
        Object object = this.regionMigrateLock;
        synchronized (object) {
            TSStatus migrateStatus = req.getMigrateResult();
            if (migrateStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOG.info("{}, Region migrate failed in DataNode, migrateStatus: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)migrateStatus);
                this.migrateSuccess = false;
                this.migrateResult = migrateStatus.toString();
            }
            this.regionMigrateLock.notify();
        }
    }

    public TConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }
}

