/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition.maintainer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionCreateTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionDeleteTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public abstract class RegionMaintainTask {
    protected final RegionMaintainType type;
    protected TDataNodeLocation targetDataNode;

    public RegionMaintainTask(RegionMaintainType type) {
        this.type = type;
    }

    public RegionMaintainType getType() {
        return this.type;
    }

    public TDataNodeLocation getTargetDataNode() {
        return this.targetDataNode;
    }

    public void setTargetDataNode(TDataNodeLocation targetDataNode) {
        this.targetDataNode = targetDataNode;
    }

    public abstract void serialize(DataOutputStream var1) throws IOException;

    protected abstract void deserialize(ByteBuffer var1) throws IOException;

    public abstract void serialize(OutputStream var1, TProtocol var2) throws IOException, TException;

    protected abstract void deserialize(InputStream var1, TProtocol var2) throws TException, IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegionMaintainTask)) {
            return false;
        }
        RegionMaintainTask task = (RegionMaintainTask)o;
        return this.type == task.type && this.targetDataNode.equals(task.targetDataNode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.targetDataNode});
    }

    public static class Factory {
        public static RegionMaintainTask create(ByteBuffer buffer) throws IOException {
            RegionMaintainTask task;
            int typeNum = buffer.getInt();
            if (typeNum >= RegionMaintainType.values().length) {
                throw new IOException("Unrecognized RegionMaintainType: " + typeNum);
            }
            RegionMaintainType type = RegionMaintainType.values()[typeNum];
            switch (type) {
                case CREATE: {
                    task = new RegionCreateTask();
                    break;
                }
                case DELETE: {
                    task = new RegionDeleteTask();
                    break;
                }
                default: {
                    throw new IOException("Unrecognized RegionMaintainType: " + typeNum);
                }
            }
            task.deserialize(buffer);
            return task;
        }

        public static RegionMaintainTask create(InputStream inputStream, TProtocol protocol) throws IOException, TException {
            RegionMaintainTask task;
            int typeNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
            if (typeNum >= RegionMaintainType.values().length) {
                throw new IOException("Unrecognized RegionMaintainType: " + typeNum);
            }
            RegionMaintainType type = RegionMaintainType.values()[typeNum];
            switch (type) {
                case CREATE: {
                    task = new RegionCreateTask();
                    break;
                }
                case DELETE: {
                    task = new RegionDeleteTask();
                    break;
                }
                default: {
                    throw new IOException("Unrecognized RegionMaintainType: " + typeNum);
                }
            }
            task.deserialize(inputStream, protocol);
            return task;
        }

        private Factory() {
        }
    }
}

