/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition.maintainer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class RegionDeleteTask
extends RegionMaintainTask {
    private TConsensusGroupId regionId;

    public RegionDeleteTask() {
        super(RegionMaintainType.DELETE);
    }

    public RegionDeleteTask(TDataNodeLocation targetDataNode, TConsensusGroupId regionId) {
        super(RegionMaintainType.DELETE);
        this.targetDataNode = targetDataNode;
        this.regionId = regionId;
    }

    public TConsensusGroupId getRegionId() {
        return this.regionId;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(RegionMaintainType.DELETE.ordinal());
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.targetDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.regionId, (DataOutputStream)stream);
    }

    @Override
    protected void deserialize(ByteBuffer buffer) throws IOException {
        this.targetDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer);
        this.regionId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)buffer);
    }

    @Override
    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((int)RegionMaintainType.DELETE.ordinal(), (OutputStream)outputStream);
        this.targetDataNode.write(protocol);
        this.regionId.write(protocol);
    }

    @Override
    protected void deserialize(InputStream inputStream, TProtocol protocol) throws TException {
        this.targetDataNode = new TDataNodeLocation();
        this.targetDataNode.read(protocol);
        this.regionId = new TConsensusGroupId();
        this.regionId.read(protocol);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegionDeleteTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegionDeleteTask that = (RegionDeleteTask)o;
        return this.regionId.equals(that.regionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.regionId);
    }
}

