/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition.heartbeat;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionCache;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionStatistics;

public class RegionGroupCache {
    private final TConsensusGroupId consensusGroupId;
    private final Map<Integer, RegionCache> regionCacheMap;
    protected volatile RegionGroupStatistics previousStatistics;
    private volatile RegionGroupStatistics currentStatistics;

    public RegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.consensusGroupId = consensusGroupId;
        this.regionCacheMap = new ConcurrentHashMap<Integer, RegionCache>();
        this.previousStatistics = RegionGroupStatistics.generateDefaultRegionGroupStatistics();
        this.currentStatistics = RegionGroupStatistics.generateDefaultRegionGroupStatistics();
    }

    public void cacheHeartbeatSample(int dataNodeId, RegionHeartbeatSample newHeartbeatSample) {
        this.regionCacheMap.computeIfAbsent(dataNodeId, empty -> new RegionCache()).cacheHeartbeatSample(newHeartbeatSample);
    }

    public boolean periodicUpdate() {
        this.updateCurrentStatistics();
        if (!this.currentStatistics.equals(this.previousStatistics)) {
            this.previousStatistics = this.currentStatistics.deepCopy();
            return true;
        }
        return false;
    }

    public void forceUpdate(Map<Integer, RegionHeartbeatSample> newHeartbeatSamples) {
        newHeartbeatSamples.forEach(this::cacheHeartbeatSample);
        this.updateCurrentStatistics();
    }

    protected void updateCurrentStatistics() {
        HashMap<Integer, RegionStatistics> regionStatisticsMap = new HashMap<Integer, RegionStatistics>();
        for (Map.Entry<Integer, RegionCache> cacheEntry : this.regionCacheMap.entrySet()) {
            RegionStatistics regionStatistics = cacheEntry.getValue().getRegionStatistics();
            regionStatisticsMap.put(cacheEntry.getKey(), regionStatistics);
        }
        RegionGroupStatus status = this.updateRegionGroupStatus(regionStatisticsMap);
        RegionGroupStatistics newRegionGroupStatistics = new RegionGroupStatistics(status, regionStatisticsMap);
        if (!this.currentStatistics.equals(newRegionGroupStatistics)) {
            this.currentStatistics = newRegionGroupStatistics;
        }
    }

    private RegionGroupStatus updateRegionGroupStatus(Map<Integer, RegionStatistics> regionStatisticsMap) {
        int unknownCount = 0;
        for (RegionStatistics regionStatistics : regionStatisticsMap.values()) {
            if (RegionStatus.ReadOnly.equals((Object)regionStatistics.getRegionStatus()) || RegionStatus.Removing.equals((Object)regionStatistics.getRegionStatus())) {
                return RegionGroupStatus.Disabled;
            }
            unknownCount += RegionStatus.Unknown.equals((Object)regionStatistics.getRegionStatus()) ? 1 : 0;
        }
        if (unknownCount == 0) {
            return RegionGroupStatus.Running;
        }
        return unknownCount <= (this.regionCacheMap.size() - 1) / 2 ? RegionGroupStatus.Available : RegionGroupStatus.Disabled;
    }

    public void removeCacheIfExists(int dataNodeId) {
        this.regionCacheMap.remove(dataNodeId);
    }

    public RegionGroupStatistics getStatistics() {
        return this.currentStatistics;
    }
}

