/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.rpc.thrift.TCQConfig;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.apache.iotdb.confignode.rpc.thrift.TRatisConfig;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DataNodeRegisterResp
implements DataSet {
    private TSStatus status;
    private List<TConfigNodeLocation> configNodeList;
    private Integer dataNodeId = null;
    private TGlobalConfig globalConfig = null;
    private TRatisConfig ratisConfig;
    private TCQConfig cqConfig;
    private byte[] templateInfo;
    private List<ByteBuffer> allTriggerInformation;
    private List<ByteBuffer> allUDFInformation;
    private byte[] allTTLInformation;

    public TSStatus getStatus() {
        return this.status;
    }

    public void setStatus(TSStatus status) {
        this.status = status;
    }

    public void setConfigNodeList(List<TConfigNodeLocation> configNodeList) {
        this.configNodeList = configNodeList;
    }

    public void setDataNodeId(Integer dataNodeId) {
        this.dataNodeId = dataNodeId;
    }

    public void setGlobalConfig(TGlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public void setRatisConfig(TRatisConfig ratisConfig) {
        this.ratisConfig = ratisConfig;
    }

    public void setCqConfig(TCQConfig cqConfig) {
        this.cqConfig = cqConfig;
    }

    public void setTemplateInfo(byte[] templateInfo) {
        this.templateInfo = templateInfo;
    }

    public List<ByteBuffer> getTriggerInformation() {
        return this.allTriggerInformation;
    }

    public void setTriggerInformation(List<ByteBuffer> triggerInformation) {
        this.allTriggerInformation = triggerInformation;
    }

    public void setAllUDFInformation(List<ByteBuffer> allUDFInformation) {
        this.allUDFInformation = allUDFInformation;
    }

    public void setAllTTLInformation(Map<String, Long> allTTLInformation) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)allTTLInformation.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Long> entry : allTTLInformation.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)entry.getValue(), (OutputStream)outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.allTTLInformation = outputStream.toByteArray();
    }

    public TDataNodeRegisterResp convertToRpcDataNodeRegisterResp() {
        TDataNodeRegisterResp resp = new TDataNodeRegisterResp();
        resp.setStatus(this.status);
        resp.setConfigNodeList(this.configNodeList);
        if (this.status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || this.status.getCode() == TSStatusCode.DATANODE_ALREADY_REGISTERED.getStatusCode() || this.status.getCode() == TSStatusCode.DATANODE_NOT_EXIST.getStatusCode()) {
            resp.setDataNodeId(this.dataNodeId.intValue());
            resp.setGlobalConfig(this.globalConfig);
            resp.setTemplateInfo(this.templateInfo);
            resp.setRatisConfig(this.ratisConfig);
            resp.setCqConfig(this.cqConfig);
            resp.setAllTriggerInformation(this.allTriggerInformation);
            resp.setAllUDFInformation(this.allUDFInformation);
            resp.setAllTTLInformation(this.allTTLInformation);
        }
        return resp;
    }
}

