/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.storagegroup;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetDataReplicationFactorPlan
extends ConfigPhysicalPlan {
    private String storageGroup;
    private int dataReplicationFactor;

    public SetDataReplicationFactorPlan() {
        super(ConfigPhysicalPlanType.SetDataReplicationFactor);
    }

    public SetDataReplicationFactorPlan(String storageGroup, int dataReplicationFactor) {
        this();
        this.storageGroup = storageGroup;
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public int getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        BasicStructureSerDeUtil.write((String)this.storageGroup, (DataOutputStream)stream);
        stream.writeInt(this.dataReplicationFactor);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.dataReplicationFactor = buffer.getInt();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetDataReplicationFactorPlan that = (SetDataReplicationFactorPlan)o;
        return this.dataReplicationFactor == that.dataReplicationFactor && this.storageGroup.equals(that.storageGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.storageGroup, this.dataReplicationFactor);
    }
}

