/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.sync;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TDisableDataNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidatePermissionCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDataNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDataNodeClientPool.class);
    private static final int DEFAULT_RETRY_NUM = 6;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());

    private SyncDataNodeClientPool() {
    }

    public TSStatus sendSyncRequestToDataNodeWithRetry(TEndPoint endPoint, Object req, DataNodeRequestType requestType) {
        Throwable lastException = new TException();
        int retry = 0;
        while (retry < 6) {
            TSStatus tSStatus;
            block10: {
                SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);
                try {
                    tSStatus = this.executeSyncRequest(requestType, client, req);
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | TException e) {
                        lastException = e;
                        if (retry != 5) {
                            LOGGER.warn("{} failed on DataNode {}, retrying {}...", new Object[]{requestType, endPoint, retry + 1});
                            this.doRetryWait(retry);
                        }
                        ++retry;
                    }
                }
                client.close();
            }
            return tSStatus;
        }
        LOGGER.error("{} failed on DataNode {}", new Object[]{requestType, endPoint, lastException});
        return new TSStatus(TSStatusCode.INTERNAL_REQUEST_RETRY_ERROR.getStatusCode()).setMessage("All retry failed due to: " + lastException.getMessage());
    }

    public TSStatus sendSyncRequestToDataNodeWithGivenRetry(TEndPoint endPoint, Object req, DataNodeRequestType requestType, int retryNum) {
        Throwable lastException = new TException();
        int retry = 0;
        while (retry < retryNum) {
            TSStatus tSStatus;
            block10: {
                SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)endPoint);
                try {
                    tSStatus = this.executeSyncRequest(requestType, client, req);
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | TException e) {
                        lastException = e;
                        if (retry != retryNum - 1) {
                            LOGGER.warn("{} failed on DataNode {}, retrying {}...", new Object[]{requestType, endPoint, retry + 1});
                            this.doRetryWait(retry);
                        }
                        ++retry;
                    }
                }
                client.close();
            }
            return tSStatus;
        }
        LOGGER.error("{} failed on DataNode {}", new Object[]{requestType, endPoint, lastException});
        return new TSStatus(TSStatusCode.INTERNAL_REQUEST_RETRY_ERROR.getStatusCode()).setMessage("All retry failed due to: " + lastException.getMessage());
    }

    private TSStatus executeSyncRequest(DataNodeRequestType requestType, SyncDataNodeInternalServiceClient client, Object req) throws TException {
        switch (requestType) {
            case INVALIDATE_PARTITION_CACHE: {
                return client.invalidatePartitionCache((TInvalidateCacheReq)req);
            }
            case INVALIDATE_SCHEMA_CACHE: {
                return client.invalidateSchemaCache((TInvalidateCacheReq)req);
            }
            case CREATE_SCHEMA_REGION: {
                return client.createSchemaRegion((TCreateSchemaRegionReq)req);
            }
            case CREATE_DATA_REGION: {
                return client.createDataRegion((TCreateDataRegionReq)req);
            }
            case DELETE_REGION: {
                return client.deleteRegion((TConsensusGroupId)req);
            }
            case INVALIDATE_PERMISSION_CACHE: {
                return client.invalidatePermissionCache((TInvalidatePermissionCacheReq)req);
            }
            case DISABLE_DATA_NODE: {
                return client.disableDataNode((TDisableDataNodeReq)req);
            }
            case STOP_DATA_NODE: {
                return client.stopDataNode();
            }
            case SET_SYSTEM_STATUS: {
                return client.setSystemStatus((String)req);
            }
            case UPDATE_TEMPLATE: {
                return client.updateTemplate((TUpdateTemplateReq)req);
            }
            case CREATE_NEW_REGION_PEER: {
                return client.createNewRegionPeer((TCreatePeerReq)req);
            }
            case ADD_REGION_PEER: {
                return client.addRegionPeer((TMaintainPeerReq)req);
            }
            case REMOVE_REGION_PEER: {
                return client.removeRegionPeer((TMaintainPeerReq)req);
            }
            case DELETE_OLD_REGION_PEER: {
                return client.deleteOldRegionPeer((TMaintainPeerReq)req);
            }
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)("Unknown request type: " + (Object)((Object)requestType)));
    }

    private void doRetryWait(int retryNum) {
        try {
            if (retryNum < 3) {
                TimeUnit.MILLISECONDS.sleep(800L);
            } else if (retryNum < 5) {
                TimeUnit.MILLISECONDS.sleep(100L * (long)Math.pow(2.0, retryNum));
            } else {
                TimeUnit.MILLISECONDS.sleep(3200L);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Retry wait failed.", (Throwable)e);
        }
    }

    public TSStatus changeRegionLeader(TConsensusGroupId regionId, TEndPoint dataNode, TDataNodeLocation newLeaderNode) {
        TSStatus status;
        LOGGER.info("Send RPC to data node: {} for changing regions leader on it", (Object)dataNode);
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)dataNode);){
            TRegionLeaderChangeReq req = new TRegionLeaderChangeReq(regionId, newLeaderNode);
            status = client.changeRegionLeader(req);
        }
        catch (IOException e) {
            LOGGER.error("Can't connect to Data node: {}", (Object)dataNode, (Object)e);
            status = new TSStatus(TSStatusCode.CAN_NOT_CONNECT_DATANODE.getStatusCode());
            status.setMessage(e.getMessage());
        }
        catch (TException e) {
            LOGGER.error("Change regions leader error on Date node: {}", (Object)dataNode, (Object)e);
            status = new TSStatus(TSStatusCode.REGION_LEADER_CHANGE_ERROR.getStatusCode());
            status.setMessage(e.getMessage());
        }
        return status;
    }

    public static SyncDataNodeClientPool getInstance() {
        return ClientPoolHolder.INSTANCE;
    }

    private static class ClientPoolHolder {
        private static final SyncDataNodeClientPool INSTANCE = new SyncDataNodeClientPool();

        private ClientPoolHolder() {
        }
    }
}

