/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFClassLoaderManager
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFClassLoaderManager.class);
    private final String libRoot;
    private final Map<Long, UDFClassLoader> queryIdToUDFClassLoaderMap;
    private volatile UDFClassLoader activeClassLoader;
    private static UDFClassLoaderManager INSTANCE = null;

    private UDFClassLoaderManager(String libRoot) {
        this.libRoot = libRoot;
        LOGGER.info("UDF lib root: {}", (Object)libRoot);
        this.queryIdToUDFClassLoaderMap = new ConcurrentHashMap<Long, UDFClassLoader>();
        this.activeClassLoader = null;
    }

    public void initializeUDFQuery(long queryId) {
        this.activeClassLoader.acquire();
        this.queryIdToUDFClassLoaderMap.put(queryId, this.activeClassLoader);
    }

    public void finalizeUDFQuery(long queryId) {
        UDFClassLoader classLoader = this.queryIdToUDFClassLoaderMap.remove(queryId);
        try {
            if (classLoader != null) {
                classLoader.release();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close UDFClassLoader (queryId: {}), because {}", (Object)queryId, (Object)e.toString());
        }
    }

    public UDFClassLoader updateAndGetActiveClassLoader() throws IOException {
        UDFClassLoader deprecatedClassLoader = this.activeClassLoader;
        this.activeClassLoader = new UDFClassLoader(this.libRoot);
        if (deprecatedClassLoader != null) {
            deprecatedClassLoader.markAsDeprecated();
        }
        return this.activeClassLoader;
    }

    public UDFClassLoader getActiveClassLoader() {
        return this.activeClassLoader;
    }

    @Override
    public void start() throws StartupException {
        try {
            SystemFileFactory.INSTANCE.makeDirIfNecessary(this.libRoot);
            this.activeClassLoader = new UDFClassLoader(this.libRoot);
        }
        catch (IOException e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.UDF_CLASSLOADER_MANAGER_SERVICE;
    }

    public static synchronized UDFClassLoaderManager setupAndGetInstance(String libRoot) {
        if (INSTANCE == null) {
            INSTANCE = new UDFClassLoaderManager(libRoot);
        }
        return INSTANCE;
    }

    public static UDFClassLoaderManager getInstance() {
        return INSTANCE;
    }
}

