/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.exception.UDFParameterNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFM4
implements UDTF {
    protected AccessStrategy accessStrategy;
    protected TSDataType dataType;
    public static final String WINDOW_SIZE_KEY = "windowSize";
    public static final String TIME_INTERVAL_KEY = "timeInterval";
    public static final String SLIDING_STEP_KEY = "slidingStep";
    public static final String DISPLAY_WINDOW_BEGIN_KEY = "displayWindowBegin";
    public static final String DISPLAY_WINDOW_END_KEY = "displayWindowEnd";

    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
        if (!validator.getParameters().hasAttribute(WINDOW_SIZE_KEY) && !validator.getParameters().hasAttribute(TIME_INTERVAL_KEY)) {
            throw new UDFParameterNotValidException(String.format("attribute \"%s\"/\"%s\" is required but was not provided.", WINDOW_SIZE_KEY, TIME_INTERVAL_KEY));
        }
        if (validator.getParameters().hasAttribute(WINDOW_SIZE_KEY) && validator.getParameters().hasAttribute(TIME_INTERVAL_KEY)) {
            throw new UDFParameterNotValidException(String.format("use attribute \"%s\" or \"%s\" only one at a time.", WINDOW_SIZE_KEY, TIME_INTERVAL_KEY));
        }
        this.accessStrategy = validator.getParameters().hasAttribute(WINDOW_SIZE_KEY) ? AccessStrategy.SIZE_WINDOW : AccessStrategy.TIME_WINDOW;
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(validator.getParameters().getDataType(0));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        configurations.setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.dataType));
        if (this.accessStrategy == AccessStrategy.SIZE_WINDOW) {
            int windowSize = parameters.getInt(WINDOW_SIZE_KEY);
            int slidingStep = parameters.getIntOrDefault(SLIDING_STEP_KEY, windowSize);
            configurations.setAccessStrategy((org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy)new SlidingSizeWindowAccessStrategy(windowSize, slidingStep));
        } else {
            long timeInterval = parameters.getLong(TIME_INTERVAL_KEY);
            long displayWindowBegin = parameters.getLongOrDefault(DISPLAY_WINDOW_BEGIN_KEY, Long.MIN_VALUE);
            long displayWindowEnd = parameters.getLongOrDefault(DISPLAY_WINDOW_END_KEY, Long.MAX_VALUE);
            long slidingStep = parameters.getLongOrDefault(SLIDING_STEP_KEY, timeInterval);
            configurations.setAccessStrategy((org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy)new SlidingTimeWindowAccessStrategy(timeInterval, slidingStep, displayWindowBegin, displayWindowEnd));
        }
    }

    public void transform(RowWindow rowWindow, PointCollector collector) throws UDFException, IOException {
        switch (this.dataType) {
            case INT32: {
                this.transformInt(rowWindow, collector);
                break;
            }
            case INT64: {
                this.transformLong(rowWindow, collector);
                break;
            }
            case FLOAT: {
                this.transformFloat(rowWindow, collector);
                break;
            }
            case DOUBLE: {
                this.transformDouble(rowWindow, collector);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
    }

    public void transformInt(RowWindow rowWindow, PointCollector collector) throws IOException {
        int firstValue = rowWindow.getRow(0).getInt(0);
        int lastValue = rowWindow.getRow(rowWindow.windowSize() - 1).getInt(0);
        int minValue = Math.min(firstValue, lastValue);
        int maxValue = Math.max(firstValue, lastValue);
        int minIndex = firstValue < lastValue ? 0 : rowWindow.windowSize() - 1;
        int maxIndex = firstValue > lastValue ? 0 : rowWindow.windowSize() - 1;
        for (int i = 1; i < rowWindow.windowSize() - 1; ++i) {
            int value = rowWindow.getRow(i).getInt(0);
            if (value < minValue) {
                minValue = value;
                minIndex = i;
            }
            if (value <= maxValue) continue;
            maxValue = value;
            maxIndex = i;
        }
        Row row = rowWindow.getRow(0);
        collector.putInt(row.getTime(), row.getInt(0));
        int smallerIndex = Math.min(minIndex, maxIndex);
        int largerIndex = Math.max(minIndex, maxIndex);
        if (smallerIndex > 0) {
            row = rowWindow.getRow(smallerIndex);
            collector.putInt(row.getTime(), row.getInt(0));
        }
        if (largerIndex > smallerIndex) {
            row = rowWindow.getRow(largerIndex);
            collector.putInt(row.getTime(), row.getInt(0));
        }
        if (largerIndex < rowWindow.windowSize() - 1) {
            row = rowWindow.getRow(rowWindow.windowSize() - 1);
            collector.putInt(row.getTime(), row.getInt(0));
        }
    }

    public void transformLong(RowWindow rowWindow, PointCollector collector) throws IOException {
        long firstValue = rowWindow.getRow(0).getLong(0);
        long lastValue = rowWindow.getRow(rowWindow.windowSize() - 1).getLong(0);
        long minValue = Math.min(firstValue, lastValue);
        long maxValue = Math.max(firstValue, lastValue);
        int minIndex = firstValue < lastValue ? 0 : rowWindow.windowSize() - 1;
        int maxIndex = firstValue > lastValue ? 0 : rowWindow.windowSize() - 1;
        for (int i = 1; i < rowWindow.windowSize() - 1; ++i) {
            long value = rowWindow.getRow(i).getLong(0);
            if (value < minValue) {
                minValue = value;
                minIndex = i;
            }
            if (value <= maxValue) continue;
            maxValue = value;
            maxIndex = i;
        }
        Row row = rowWindow.getRow(0);
        collector.putLong(row.getTime(), row.getLong(0));
        int smallerIndex = Math.min(minIndex, maxIndex);
        int largerIndex = Math.max(minIndex, maxIndex);
        if (smallerIndex > 0) {
            row = rowWindow.getRow(smallerIndex);
            collector.putLong(row.getTime(), row.getLong(0));
        }
        if (largerIndex > smallerIndex) {
            row = rowWindow.getRow(largerIndex);
            collector.putLong(row.getTime(), row.getLong(0));
        }
        if (largerIndex < rowWindow.windowSize() - 1) {
            row = rowWindow.getRow(rowWindow.windowSize() - 1);
            collector.putLong(row.getTime(), row.getLong(0));
        }
    }

    public void transformFloat(RowWindow rowWindow, PointCollector collector) throws IOException {
        float firstValue = rowWindow.getRow(0).getFloat(0);
        float lastValue = rowWindow.getRow(rowWindow.windowSize() - 1).getFloat(0);
        float minValue = Math.min(firstValue, lastValue);
        float maxValue = Math.max(firstValue, lastValue);
        int minIndex = firstValue < lastValue ? 0 : rowWindow.windowSize() - 1;
        int maxIndex = firstValue > lastValue ? 0 : rowWindow.windowSize() - 1;
        for (int i = 1; i < rowWindow.windowSize() - 1; ++i) {
            float value = rowWindow.getRow(i).getFloat(0);
            if (value < minValue) {
                minValue = value;
                minIndex = i;
            }
            if (!(value > maxValue)) continue;
            maxValue = value;
            maxIndex = i;
        }
        Row row = rowWindow.getRow(0);
        collector.putFloat(row.getTime(), row.getFloat(0));
        int smallerIndex = Math.min(minIndex, maxIndex);
        int largerIndex = Math.max(minIndex, maxIndex);
        if (smallerIndex > 0) {
            row = rowWindow.getRow(smallerIndex);
            collector.putFloat(row.getTime(), row.getFloat(0));
        }
        if (largerIndex > smallerIndex) {
            row = rowWindow.getRow(largerIndex);
            collector.putFloat(row.getTime(), row.getFloat(0));
        }
        if (largerIndex < rowWindow.windowSize() - 1) {
            row = rowWindow.getRow(rowWindow.windowSize() - 1);
            collector.putFloat(row.getTime(), row.getFloat(0));
        }
    }

    public void transformDouble(RowWindow rowWindow, PointCollector collector) throws IOException {
        double firstValue = rowWindow.getRow(0).getDouble(0);
        double lastValue = rowWindow.getRow(rowWindow.windowSize() - 1).getDouble(0);
        double minValue = Math.min(firstValue, lastValue);
        double maxValue = Math.max(firstValue, lastValue);
        int minIndex = firstValue < lastValue ? 0 : rowWindow.windowSize() - 1;
        int maxIndex = firstValue > lastValue ? 0 : rowWindow.windowSize() - 1;
        for (int i = 1; i < rowWindow.windowSize() - 1; ++i) {
            double value = rowWindow.getRow(i).getDouble(0);
            if (value < minValue) {
                minValue = value;
                minIndex = i;
            }
            if (!(value > maxValue)) continue;
            maxValue = value;
            maxIndex = i;
        }
        Row row = rowWindow.getRow(0);
        collector.putDouble(row.getTime(), row.getDouble(0));
        int smallerIndex = Math.min(minIndex, maxIndex);
        int largerIndex = Math.max(minIndex, maxIndex);
        if (smallerIndex > 0) {
            row = rowWindow.getRow(smallerIndex);
            collector.putDouble(row.getTime(), row.getDouble(0));
        }
        if (largerIndex > smallerIndex) {
            row = rowWindow.getRow(largerIndex);
            collector.putDouble(row.getTime(), row.getDouble(0));
        }
        if (largerIndex < rowWindow.windowSize() - 1) {
            row = rowWindow.getRow(rowWindow.windowSize() - 1);
            collector.putDouble(row.getTime(), row.getDouble(0));
        }
    }

    static enum AccessStrategy {
        SIZE_WINDOW,
        TIME_WINDOW;

    }
}

