/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class TsFileGeneratorUtils {
    private static final FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    public static final String testStorageGroup = "root.testsg";
    public static int alignDeviceOffset = 10000;

    public static void writeWithTsRecord(TsFileWriter tsFileWriter, String deviceId, List<MeasurementSchema> schemas, long rowSize, long startTime, long startValue, boolean isAligned) throws IOException, WriteProcessException {
        long time = startTime;
        while (time < rowSize + startTime) {
            TSRecord tsRecord = new TSRecord(time, deviceId);
            for (IMeasurementSchema iMeasurementSchema : schemas) {
                LongDataPoint dPoint = new LongDataPoint(iMeasurementSchema.getMeasurementId(), startValue);
                tsRecord.addTuple(dPoint);
            }
            if (isAligned) {
                tsFileWriter.writeAligned(tsRecord);
            } else {
                tsFileWriter.write(tsRecord);
            }
            ++time;
            ++startValue;
        }
    }

    public static void writeWithTablet(TsFileWriter tsFileWriter, String deviceId, List<MeasurementSchema> schemas, long rowNum, long startTime, long startValue, boolean isAligned) throws IOException, WriteProcessException {
        Tablet tablet = new Tablet(deviceId, schemas);
        long[] timestamps = tablet.timestamps;
        Object[] values = tablet.values;
        long sensorNum = schemas.size();
        long r = 0L;
        while (r < rowNum) {
            ++tablet.rowSize;
            ++startTime;
            int i = 0;
            while ((long)i < sensorNum) {
                long[] sensor = (long[])values[i];
                sensor[row] = startValue;
                ++i;
            }
            if (tablet.rowSize == tablet.getMaxRowNumber()) {
                if (isAligned) {
                    tsFileWriter.writeAligned(tablet);
                } else {
                    tsFileWriter.write(tablet);
                }
                tablet.reset();
            }
            ++r;
            ++startValue;
        }
        if (tablet.rowSize != 0) {
            if (isAligned) {
                tsFileWriter.writeAligned(tablet);
            } else {
                tsFileWriter.write(tablet);
            }
            tablet.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generateMixTsFile(String filePath, int deviceNum, int measurementNum, int pointNum, int startTime, int startValue, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        int originGroupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
        int originPageSize = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        try {
            if (chunkGroupSize > 0) {
                TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
            }
            if (pageSize > 0) {
                TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
            }
            try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
                int i;
                int i2;
                ArrayList<MeasurementSchema> alignedMeasurementSchemas = new ArrayList<MeasurementSchema>();
                for (i2 = 0; i2 < measurementNum; ++i2) {
                    alignedMeasurementSchemas.add(new MeasurementSchema("s" + i2, TSDataType.INT64, TSEncoding.PLAIN));
                }
                for (i2 = alignDeviceOffset; i2 < alignDeviceOffset + deviceNum; ++i2) {
                    tsFileWriter.registerAlignedTimeseries(new Path("root.testsg.d" + i2), alignedMeasurementSchemas);
                }
                for (i2 = alignDeviceOffset; i2 < alignDeviceOffset + deviceNum; ++i2) {
                    TsFileGeneratorUtils.writeWithTsRecord(tsFileWriter, "root.testsg.d" + i2, alignedMeasurementSchemas, pointNum, startTime, startValue, true);
                }
                ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
                for (i = 0; i < measurementNum; ++i) {
                    measurementSchemas.add(new MeasurementSchema("s" + i, TSDataType.INT64, TSEncoding.PLAIN));
                }
                for (i = 0; i < deviceNum; ++i) {
                    tsFileWriter.registerTimeseries(new Path("root.testsg.d" + i), measurementSchemas);
                }
                for (i = 0; i < deviceNum; ++i) {
                    TsFileGeneratorUtils.writeWithTsRecord(tsFileWriter, "root.testsg.d" + i, measurementSchemas, pointNum, startTime, startValue, false);
                }
            }
            File file2 = file;
            return file2;
        }
        finally {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(originGroupSize);
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(originPageSize);
        }
    }

    public static File generateAlignedTsFile(String filePath, int deviceNum, int measurementNum, int pointNum, int startTime, int startValue, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        if (chunkGroupSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
        }
        if (pageSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
        }
        try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
            int i;
            ArrayList<MeasurementSchema> alignedMeasurementSchemas = new ArrayList<MeasurementSchema>();
            for (i = 0; i < measurementNum; ++i) {
                alignedMeasurementSchemas.add(new MeasurementSchema("s" + i, TSDataType.INT64, TSEncoding.PLAIN));
            }
            for (i = alignDeviceOffset; i < alignDeviceOffset + deviceNum; ++i) {
                tsFileWriter.registerAlignedTimeseries(new Path("root.testsg.d" + i), alignedMeasurementSchemas);
            }
            for (i = alignDeviceOffset; i < alignDeviceOffset + deviceNum; ++i) {
                TsFileGeneratorUtils.writeWithTsRecord(tsFileWriter, "root.testsg.d" + i, alignedMeasurementSchemas, pointNum, startTime, startValue, true);
            }
        }
        return file;
    }

    public static File generateNonAlignedTsFile(String filePath, int deviceNum, int measurementNum, int pointNum, int startTime, int startValue, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        if (chunkGroupSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
        }
        if (pageSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
        }
        try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
            int i;
            ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
            for (i = 0; i < measurementNum; ++i) {
                measurementSchemas.add(new MeasurementSchema("s" + i, TSDataType.INT64, TSEncoding.PLAIN));
            }
            for (i = 0; i < deviceNum; ++i) {
                tsFileWriter.registerTimeseries(new Path("root.testsg.d" + i), measurementSchemas);
            }
            for (i = 0; i < deviceNum; ++i) {
                TsFileGeneratorUtils.writeWithTsRecord(tsFileWriter, "root.testsg.d" + i, measurementSchemas, pointNum, startTime, startValue, false);
            }
            File file2 = file;
            return file2;
        }
    }

    public static File generateAlignedTsFileWithTextValues(String filePath, List<Integer> deviceIndex, List<Integer> measurementIndex, int pointNum, int startTime, String value, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        if (chunkGroupSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
        }
        if (pageSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
        }
        try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
            int i;
            ArrayList<MeasurementSchema> alignedMeasurementSchemas = new ArrayList<MeasurementSchema>();
            for (i = 0; i < measurementIndex.size(); ++i) {
                alignedMeasurementSchemas.add(new MeasurementSchema("s" + measurementIndex.get(i), TSDataType.TEXT, TSEncoding.PLAIN));
            }
            for (i = 0; i < deviceIndex.size(); ++i) {
                tsFileWriter.registerAlignedTimeseries(new Path("root.testsg.d" + (deviceIndex.get(i) + alignDeviceOffset)), alignedMeasurementSchemas);
            }
            for (i = 0; i < deviceIndex.size(); ++i) {
                for (long time = (long)startTime; time < (long)(pointNum + startTime); ++time) {
                    TSRecord tsRecord = new TSRecord(time, "root.testsg.d" + (deviceIndex.get(i) + alignDeviceOffset));
                    for (IMeasurementSchema iMeasurementSchema : alignedMeasurementSchemas) {
                        StringDataPoint dPoint = new StringDataPoint(iMeasurementSchema.getMeasurementId(), new Binary(value));
                        tsRecord.addTuple(dPoint);
                    }
                    tsFileWriter.writeAligned(tsRecord);
                }
            }
        }
        return file;
    }

    public static File generateNonAlignedTsFileWithTextValues(String filePath, List<Integer> deviceIndex, List<Integer> measurementIndex, int pointNum, int startTime, String value, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        if (chunkGroupSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
        }
        if (pageSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
        }
        try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
            int i;
            ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
            for (i = 0; i < measurementIndex.size(); ++i) {
                measurementSchemas.add(new MeasurementSchema("s" + measurementIndex.get(i), TSDataType.TEXT, TSEncoding.PLAIN));
            }
            for (i = 0; i < deviceIndex.size(); ++i) {
                tsFileWriter.registerTimeseries(new Path("root.testsg.d" + deviceIndex.get(i)), measurementSchemas);
            }
            for (i = 0; i < deviceIndex.size(); ++i) {
                for (long time = (long)startTime; time < (long)(pointNum + startTime); ++time) {
                    TSRecord tsRecord = new TSRecord(time, "root.testsg.d" + deviceIndex.get(i));
                    for (IMeasurementSchema iMeasurementSchema : measurementSchemas) {
                        StringDataPoint dPoint = new StringDataPoint(iMeasurementSchema.getMeasurementId(), new Binary(value));
                        tsRecord.addTuple(dPoint);
                    }
                    tsFileWriter.write(tsRecord);
                }
            }
            File file2 = file;
            return file2;
        }
    }

    public static String getTsFilePath(String fileParentPath, long tsFileVersion) {
        String fileName = System.currentTimeMillis() + "-" + tsFileVersion + "-0-0.tsfile";
        return fileParentPath.concat(fileName);
    }

    public static int getAlignDeviceOffset() {
        return alignDeviceOffset;
    }
}

