/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.config;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;

public class ConsensusConfig {
    private final TEndPoint thisNodeEndPoint;
    private final int thisNodeId;
    private final String storageDir;
    private final RatisConfig ratisConfig;
    private final IoTConsensusConfig ioTConsensusConfig;

    private ConsensusConfig(TEndPoint thisNode, int thisNodeId, String storageDir, RatisConfig ratisConfig, IoTConsensusConfig ioTConsensusConfig) {
        this.thisNodeEndPoint = thisNode;
        this.thisNodeId = thisNodeId;
        this.storageDir = storageDir;
        this.ratisConfig = ratisConfig;
        this.ioTConsensusConfig = ioTConsensusConfig;
    }

    public TEndPoint getThisNodeEndPoint() {
        return this.thisNodeEndPoint;
    }

    public int getThisNodeId() {
        return this.thisNodeId;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public RatisConfig getRatisConfig() {
        return this.ratisConfig;
    }

    public IoTConsensusConfig getIoTConsensusConfig() {
        return this.ioTConsensusConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TEndPoint thisNode;
        private int thisNodeId;
        private String storageDir;
        private RatisConfig ratisConfig;
        private IoTConsensusConfig ioTConsensusConfig;

        public ConsensusConfig build() {
            return new ConsensusConfig(this.thisNode, this.thisNodeId, this.storageDir, this.ratisConfig != null ? this.ratisConfig : RatisConfig.newBuilder().build(), this.ioTConsensusConfig != null ? this.ioTConsensusConfig : IoTConsensusConfig.newBuilder().build());
        }

        public Builder setThisNode(TEndPoint thisNode) {
            this.thisNode = thisNode;
            return this;
        }

        public Builder setThisNodeId(int thisNodeId) {
            this.thisNodeId = thisNodeId;
            return this;
        }

        public Builder setStorageDir(String storageDir) {
            this.storageDir = storageDir;
            return this;
        }

        public Builder setRatisConfig(RatisConfig ratisConfig) {
            this.ratisConfig = ratisConfig;
            return this;
        }

        public Builder setIoTConsensusConfig(IoTConsensusConfig ioTConsensusConfig) {
            this.ioTConsensusConfig = ioTConsensusConfig;
            return this;
        }
    }
}

