/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.type;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.lang.ref.WeakReference;
import java.util.function.ToLongFunction;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.slf4j.LoggerFactory;

public class MicrometerAutoGauge<T>
implements AutoGauge {
    private final WeakReference<T> refObject;
    private final ToLongFunction<T> mapper;

    public MicrometerAutoGauge(MeterRegistry meterRegistry, String metricName, T object, ToLongFunction<T> mapper, String ... tags) {
        LoggerFactory.getLogger(MicrometerAutoGauge.class).info("{},{}", (Object)metricName, (Object)tags);
        this.refObject = new WeakReference<Object>(meterRegistry.gauge(metricName, (Iterable)Tags.of((String[])tags), object, value -> mapper.applyAsLong(value)));
        this.mapper = mapper;
    }

    public long value() {
        if (this.refObject.get() == null) {
            return 0L;
        }
        return this.mapper.applyAsLong(this.refObject.get());
    }
}

