/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import com.codahale.metrics.MetricRegistry;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.dropwizard.DropwizardMetricManager;
import org.apache.iotdb.metrics.reporter.JmxReporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardJmxReporter
implements JmxReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardJmxReporter.class);
    private AbstractMetricManager dropwizardMetricManager = null;
    private com.codahale.metrics.jmx.JmxReporter jmxReporter = null;

    public boolean start() {
        if (this.jmxReporter != null) {
            LOGGER.warn("Dropwizard JmxReporter already start!");
            return false;
        }
        try {
            this.jmxReporter = com.codahale.metrics.jmx.JmxReporter.forRegistry((MetricRegistry)((DropwizardMetricManager)this.dropwizardMetricManager).getMetricRegistry()).inDomain("org.apache.iotdb.metrics").build();
            this.jmxReporter.start();
        }
        catch (Exception e) {
            LOGGER.error("Failed to start Dropwizard JmxReporter, because {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean stop() {
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
            this.jmxReporter = null;
        }
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.JMX;
    }

    public void setMetricManager(AbstractMetricManager metricManager) {
        this.dropwizardMetricManager = metricManager;
    }
}

