/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public interface ReferenceCountedObject<T> {
    public T get();

    public T retain();

    public boolean release();

    public static <V> ReferenceCountedObject<V> wrap(final V value, final Runnable retainMethod, final Runnable releaseMethod) {
        Objects.requireNonNull(value, "value == null");
        Objects.requireNonNull(retainMethod, "retainMethod == null");
        Objects.requireNonNull(releaseMethod, "releaseMethod == null");
        return new ReferenceCountedObject<V>(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public V get() {
                if (this.count.get() < 0) {
                    throw new IllegalStateException("Failed to get: object has already been completely released.");
                }
                return value;
            }

            @Override
            public V retain() {
                if (this.count.getAndUpdate(n -> n < 0 ? n : n + 1) < 0) {
                    throw new IllegalStateException("Failed to retain: object has already been completely released.");
                }
                retainMethod.run();
                return value;
            }

            @Override
            public boolean release() {
                int previous = this.count.getAndUpdate(n -> n <= 1 ? -1 : n - 1);
                if (previous < 0) {
                    throw new IllegalStateException("Failed to release: object has already been completely released.");
                }
                if (previous == 0) {
                    throw new IllegalStateException("Failed to release: object has not yet been retained.");
                }
                releaseMethod.run();
                return previous == 1;
            }
        };
    }
}

