/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.node;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.common.request.IoTConsensusRequest;
import org.apache.iotdb.consensus.iot.wal.ConsensusReqReader;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.flush.FlushStatus;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.buffer.IWALBuffer;
import org.apache.iotdb.db.wal.buffer.WALBuffer;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryType;
import org.apache.iotdb.db.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.wal.buffer.WALSignalEntry;
import org.apache.iotdb.db.wal.checkpoint.CheckpointManager;
import org.apache.iotdb.db.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.wal.io.WALByteBufReader;
import org.apache.iotdb.db.wal.node.IWALNode;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.apache.iotdb.db.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALNode
implements IWALNode {
    private static final Logger logger = LoggerFactory.getLogger(WALNode.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final long DEFAULT_SAFELY_DELETED_SEARCH_INDEX = Long.MAX_VALUE;
    private static final long WAIT_FOR_NEXT_WAL_ENTRY_TIMEOUT_IN_SEC = 30L;
    private final String identifier;
    private final File logDirectory;
    private final IWALBuffer buffer;
    private final CheckpointManager checkpointManager;
    private final Map<Long, Integer> memTableSnapshotCount = new ConcurrentHashMap<Long, Integer>();
    private final AtomicLong totalCostOfFlushedMemTables = new AtomicLong();
    private final Map<Long, Long> walFileVersionId2MemTablesTotalCost = new ConcurrentHashMap<Long, Long>();
    private volatile long safelyDeletedSearchIndex = Long.MAX_VALUE;

    public WALNode(String identifier, String logDirectory) throws FileNotFoundException {
        this(identifier, logDirectory, 0L, 0L);
    }

    public WALNode(String identifier, String logDirectory, long startFileVersion, long startSearchIndex) throws FileNotFoundException {
        this.identifier = identifier;
        this.logDirectory = SystemFileFactory.INSTANCE.getFile(logDirectory);
        if (!this.logDirectory.exists() && this.logDirectory.mkdirs()) {
            logger.info("create folder {} for wal node-{}.", (Object)logDirectory, (Object)identifier);
        }
        this.buffer = new WALBuffer(identifier, logDirectory, startFileVersion, startSearchIndex);
        this.checkpointManager = new CheckpointManager(identifier, logDirectory);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertRowNode insertRowNode) {
        WALInfoEntry walEntry = new WALInfoEntry(memTableId, insertRowNode);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertTabletNode insertTabletNode, int start, int end) {
        WALInfoEntry walEntry = new WALInfoEntry(memTableId, insertTabletNode, start, end);
        return this.log(walEntry);
    }

    @Override
    public WALFlushListener log(long memTableId, DeleteDataNode deleteDataNode) {
        WALInfoEntry walEntry = new WALInfoEntry(memTableId, deleteDataNode);
        return this.log(walEntry);
    }

    private WALFlushListener log(WALEntry walEntry) {
        this.buffer.write(walEntry);
        return walEntry.getWalFlushListener();
    }

    @Override
    public void onMemTableFlushStarted(IMemTable memTable) {
    }

    @Override
    public void onMemTableFlushed(IMemTable memTable) {
        if (memTable.isSignalMemTable()) {
            return;
        }
        this.checkpointManager.makeFlushMemTableCP(memTable.getMemTableId());
        this.memTableSnapshotCount.remove(memTable.getMemTableId());
        long cost = config.isEnableMemControl() ? memTable.getTVListsRamCost() : 1L;
        long currentWALFileVersion = this.buffer.getCurrentWALFileVersion();
        this.walFileVersionId2MemTablesTotalCost.compute(currentWALFileVersion, (k, v) -> v == null ? cost : v + cost);
        this.totalCostOfFlushedMemTables.addAndGet(cost);
    }

    @Override
    public void onMemTableCreated(IMemTable memTable, String targetTsFile) {
        if (memTable.isSignalMemTable()) {
            return;
        }
        long firstFileVersionId = this.buffer.getCurrentWALFileVersion();
        MemTableInfo memTableInfo = new MemTableInfo(memTable, targetTsFile, firstFileVersionId);
        this.checkpointManager.makeCreateMemTableCP(memTableInfo);
    }

    public void deleteOutdatedFiles() {
        try {
            new DeleteOutdatedFileTask().run();
        }
        catch (Exception e) {
            logger.error("Fail to delete wal node-{}'s outdated files.", (Object)this.identifier, (Object)e);
        }
    }

    public void setSafelyDeletedSearchIndex(long safelyDeletedSearchIndex) {
        this.safelyDeletedSearchIndex = safelyDeletedSearchIndex;
    }

    public ConsensusReqReader.ReqIterator getReqIterator(long startIndex) {
        return new PlanNodeIterator(startIndex);
    }

    public long getCurrentSearchIndex() {
        return this.buffer.getCurrentSearchIndex();
    }

    public long getTotalSize() {
        return WALManager.getInstance().getTotalDiskUsage();
    }

    @Override
    public void close() {
        this.buffer.close();
        this.checkpointManager.close();
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public boolean isAllWALEntriesConsumed() {
        return this.buffer.isAllWALEntriesConsumed();
    }

    public void rollWALFile() {
        WALSignalEntry rollWALFileSignal = new WALSignalEntry(WALEntryType.ROLL_WAL_LOG_WRITER_SIGNAL, true);
        WALFlushListener walFlushListener = this.log(rollWALFileSignal);
        if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
            logger.error("Fail to trigger rolling wal node-{}'s wal file log writer.", (Object)this.identifier, (Object)walFlushListener.getCause());
        }
    }

    long getCurrentLogVersion() {
        return this.buffer.getCurrentWALFileVersion();
    }

    private class PlanNodeIterator
    implements ConsensusReqReader.ReqIterator {
        private long nextSearchIndex;
        private File[] filesToSearch = null;
        private int currentFileIndex = -1;
        private boolean needUpdatingFilesToSearch = true;
        private final List<IndexedConsensusRequest> insertNodes = new LinkedList<IndexedConsensusRequest>();
        private Iterator<IndexedConsensusRequest> itr = null;

        public PlanNodeIterator(long startIndex) {
            this.nextSearchIndex = startIndex;
        }

        public boolean hasNext() {
            long targetIndex;
            List<Object> tmpNodes;
            block38: {
                if (this.itr != null && this.itr.hasNext()) {
                    return true;
                }
                this.insertNodes.clear();
                this.itr = null;
                if (this.needUpdatingFilesToSearch || this.filesToSearch == null) {
                    this.updateFilesToSearch();
                    if (this.needUpdatingFilesToSearch) {
                        logger.debug("update file to search failed, the next search index is {}", (Object)this.nextSearchIndex);
                        return false;
                    }
                }
                while (WALFileUtils.parseStatusCode(this.filesToSearch[this.currentFileIndex].getName()) == WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) {
                    ++this.currentFileIndex;
                    if (this.currentFileIndex < this.filesToSearch.length - 1) continue;
                    this.needUpdatingFilesToSearch = true;
                    return false;
                }
                tmpNodes = new ArrayList<IoTConsensusRequest>();
                targetIndex = this.nextSearchIndex;
                try (WALByteBufReader walByteBufReader = new WALByteBufReader(this.filesToSearch[this.currentFileIndex]);){
                    while (walByteBufReader.hasNext()) {
                        ByteBuffer buffer = walByteBufReader.next();
                        WALEntryType type = WALEntryType.valueOf(buffer.get());
                        if (type.needSearch()) {
                            buffer.position(11);
                            long currentIndex = buffer.getLong();
                            buffer.clear();
                            if (currentIndex == targetIndex) {
                                tmpNodes.add(new IoTConsensusRequest(buffer));
                                continue;
                            }
                            if (!tmpNodes.isEmpty()) {
                                this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                                tmpNodes = new ArrayList();
                            }
                            if (currentIndex <= targetIndex) continue;
                            tmpNodes.add(new IoTConsensusRequest(buffer));
                            targetIndex = currentIndex;
                            continue;
                        }
                        if (tmpNodes.isEmpty()) continue;
                        this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                        ++targetIndex;
                        tmpNodes = new ArrayList();
                    }
                }
                catch (FileNotFoundException e) {
                    logger.debug("WAL file {} has been deleted, try to find next {} again.", (Object)WALNode.this.identifier, (Object)this.nextSearchIndex);
                    this.reset();
                    return this.hasNext();
                }
                catch (Exception e) {
                    logger.error("Fail to read wal from wal file {}, skip this file.", (Object)this.filesToSearch[this.currentFileIndex], (Object)e);
                    if (!this.insertNodes.isEmpty() || !tmpNodes.isEmpty()) break block38;
                    ++this.currentFileIndex;
                    return this.hasNext();
                }
            }
            if (tmpNodes.isEmpty()) {
                ++this.currentFileIndex;
            } else {
                int fileIndex = this.currentFileIndex + 1;
                while (!tmpNodes.isEmpty() && fileIndex < this.filesToSearch.length - 1) {
                    if (WALFileUtils.parseStatusCode(this.filesToSearch[fileIndex].getName()) == WALFileStatus.CONTAINS_NONE_SEARCH_INDEX) {
                        this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                        tmpNodes = Collections.emptyList();
                        break;
                    }
                    try (WALByteBufReader walByteBufReader = new WALByteBufReader(this.filesToSearch[fileIndex]);){
                        if (walByteBufReader.getFirstSearchIndex() != targetIndex) {
                            this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                            tmpNodes = Collections.emptyList();
                            break;
                        }
                        while (walByteBufReader.hasNext()) {
                            ByteBuffer buffer = walByteBufReader.next();
                            WALEntryType type = WALEntryType.valueOf(buffer.get());
                            if (type.needSearch()) {
                                buffer.position(11);
                                long currentIndex = buffer.getLong();
                                buffer.clear();
                                if (currentIndex == targetIndex) {
                                    tmpNodes.add(new IoTConsensusRequest(buffer));
                                    continue;
                                }
                                this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                                tmpNodes = Collections.emptyList();
                            } else {
                                this.insertNodes.add(new IndexedConsensusRequest(targetIndex, tmpNodes));
                                tmpNodes = Collections.emptyList();
                            }
                            break;
                        }
                    }
                    catch (FileNotFoundException e) {
                        logger.debug("WAL file {} has been deleted, try to find next {} again.", (Object)WALNode.this.identifier, (Object)this.nextSearchIndex);
                        this.reset();
                        return this.hasNext();
                    }
                    catch (Exception e) {
                        logger.error("Fail to read wal from wal file {}, skip this file.", (Object)this.filesToSearch[fileIndex], (Object)e);
                    }
                    if (tmpNodes.isEmpty()) continue;
                    ++fileIndex;
                }
                if (tmpNodes.isEmpty()) {
                    this.currentFileIndex = fileIndex;
                } else {
                    this.needUpdatingFilesToSearch = true;
                }
            }
            if (this.currentFileIndex >= this.filesToSearch.length - 1) {
                this.needUpdatingFilesToSearch = true;
            }
            if (this.insertNodes.size() != 0) {
                this.itr = this.insertNodes.iterator();
                return true;
            }
            return false;
        }

        public IndexedConsensusRequest next() {
            if (this.itr == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            IndexedConsensusRequest request = this.itr.next();
            this.nextSearchIndex = request.getSearchIndex() + 1L;
            return request;
        }

        public void waitForNextReady() throws InterruptedException {
            boolean walFileRolled = false;
            while (!this.hasNext()) {
                if (!walFileRolled) {
                    boolean timeout = !WALNode.this.buffer.waitForFlush(30L, TimeUnit.SECONDS);
                    if (!timeout) continue;
                    logger.info("timeout when waiting for next WAL entry ready, execute rollWALFile. Current search index in wal buffer is {}, and next target index is {}", (Object)WALNode.this.buffer.getCurrentSearchIndex(), (Object)this.nextSearchIndex);
                    WALNode.this.rollWALFile();
                    walFileRolled = true;
                    continue;
                }
                WALNode.this.buffer.waitForFlush();
            }
        }

        public void waitForNextReady(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (!this.hasNext()) {
                boolean timeout;
                boolean bl = timeout = !WALNode.this.buffer.waitForFlush(time, unit);
                if (timeout || !this.hasNext()) {
                    throw new TimeoutException();
                }
            }
        }

        public void skipTo(long targetIndex) {
            if (targetIndex < this.nextSearchIndex) {
                logger.warn("Skip from {} to {}, it's a dangerous operation because insert plan {} may have been lost.", new Object[]{this.nextSearchIndex, targetIndex, targetIndex});
            }
            this.reset();
            this.nextSearchIndex = targetIndex;
        }

        private void reset() {
            this.insertNodes.clear();
            this.itr = null;
            this.filesToSearch = null;
            this.currentFileIndex = -1;
            this.needUpdatingFilesToSearch = true;
        }

        private void updateFilesToSearch() {
            File[] filesToSearch = WALFileUtils.listAllWALFiles(WALNode.this.logDirectory);
            WALFileUtils.ascSortByVersionId(filesToSearch);
            int fileIndex = WALFileUtils.binarySearchFileBySearchIndex(filesToSearch, this.nextSearchIndex);
            logger.debug("searchIndex: {}, result: {}, files: {}, ", new Object[]{this.nextSearchIndex, fileIndex, filesToSearch});
            if (fileIndex == -1) {
                fileIndex = 0;
            }
            if (filesToSearch != null && fileIndex >= 0 && fileIndex < filesToSearch.length - 1) {
                this.filesToSearch = filesToSearch;
                this.currentFileIndex = fileIndex;
                this.needUpdatingFilesToSearch = false;
            } else {
                this.filesToSearch = null;
                this.currentFileIndex = -1;
                this.needUpdatingFilesToSearch = true;
            }
        }
    }

    private class DeleteOutdatedFileTask
    implements Runnable {
        private static final int MAX_RECURSION_TIME = 5;
        private long firstValidVersionId;
        private int recursionTime = 0;

        private DeleteOutdatedFileTask() {
        }

        @Override
        public void run() {
            this.firstValidVersionId = WALNode.this.checkpointManager.getFirstValidWALVersionId();
            if (this.firstValidVersionId == Long.MIN_VALUE) {
                if (WALNode.this.buffer.getCurrentWALFileSize() > 0L) {
                    WALNode.this.rollWALFile();
                }
                this.firstValidVersionId = WALNode.this.checkpointManager.getFirstValidWALVersionId();
                if (this.firstValidVersionId == Long.MIN_VALUE) {
                    this.firstValidVersionId = WALNode.this.buffer.getCurrentWALFileVersion();
                }
            }
            logger.debug("Start deleting outdated wal files for wal node-{}, the first valid version id is {}, and the safely deleted search index is {}.", new Object[]{WALNode.this.identifier, this.firstValidVersionId, WALNode.this.safelyDeletedSearchIndex});
            this.deleteOutdatedFiles();
            long costOfActiveMemTables = WALNode.this.checkpointManager.getTotalCostOfActiveMemTables();
            long costOfFlushedMemTables = WALNode.this.totalCostOfFlushedMemTables.get();
            long totalCost = costOfActiveMemTables + costOfFlushedMemTables;
            if (totalCost == 0L) {
                return;
            }
            double effectiveInfoRatio = (double)costOfActiveMemTables / (double)totalCost;
            logger.debug("Effective information ratio is {}, active memTables cost is {}, flushed memTables cost is {}", new Object[]{effectiveInfoRatio, costOfActiveMemTables, costOfFlushedMemTables});
            if (effectiveInfoRatio < config.getWalMinEffectiveInfoRatio()) {
                logger.info("Effective information ratio {} (active memTables cost is {}, flushed memTables cost is {}) of wal node-{} is below wal min effective info ratio {}, some memTables will be snapshot or flushed.", new Object[]{effectiveInfoRatio, costOfActiveMemTables, costOfFlushedMemTables, WALNode.this.identifier, config.getWalMinEffectiveInfoRatio()});
                if (this.snapshotOrFlushMemTable() && this.recursionTime < 5) {
                    if (WALNode.this.safelyDeletedSearchIndex != Long.MAX_VALUE) {
                        return;
                    }
                    ++this.recursionTime;
                    this.run();
                }
            }
        }

        private void deleteOutdatedFiles() {
            int endFileIndex;
            File[] filesToDelete = WALNode.this.logDirectory.listFiles(this::filterFilesToDelete);
            if (filesToDelete == null) {
                return;
            }
            WALFileUtils.ascSortByVersionId(filesToDelete);
            int n = endFileIndex = WALNode.this.safelyDeletedSearchIndex == Long.MAX_VALUE ? filesToDelete.length : WALFileUtils.binarySearchFileBySearchIndex(filesToDelete, WALNode.this.safelyDeletedSearchIndex + 1L);
            if (endFileIndex == -1) {
                ++endFileIndex;
            }
            while (endFileIndex < filesToDelete.length && WALFileUtils.parseStatusCode(filesToDelete[endFileIndex].getName()) != WALFileStatus.CONTAINS_SEARCH_INDEX) {
                ++endFileIndex;
            }
            int deletedFilesNum = 0;
            for (int i = 0; i < endFileIndex; ++i) {
                long fileSize = filesToDelete[i].length();
                if (filesToDelete[i].delete()) {
                    ++deletedFilesNum;
                    WALManager.getInstance().subtractTotalDiskUsage(fileSize);
                } else {
                    logger.info("Fail to delete outdated wal file {} of wal node-{}.", (Object)filesToDelete[i], (Object)WALNode.this.identifier);
                }
                long versionId = WALFileUtils.parseVersionId(filesToDelete[i].getName());
                Long memTableRamCostSum = (Long)WALNode.this.walFileVersionId2MemTablesTotalCost.remove(versionId);
                if (memTableRamCostSum == null) continue;
                WALNode.this.totalCostOfFlushedMemTables.addAndGet(-memTableRamCostSum.longValue());
            }
            logger.debug("Successfully delete {} outdated wal files for wal node-{}.", (Object)deletedFilesNum, (Object)WALNode.this.identifier);
        }

        private boolean filterFilesToDelete(File dir, String name) {
            Pattern pattern = WALFileUtils.WAL_FILE_NAME_PATTERN;
            Matcher matcher = pattern.matcher(name);
            boolean toDelete = false;
            if (matcher.find()) {
                long versionId = Long.parseLong(matcher.group("versionId"));
                toDelete = versionId < this.firstValidVersionId;
            }
            return toDelete;
        }

        private boolean snapshotOrFlushMemTable() {
            DataRegion dataRegion;
            MemTableInfo oldestMemTableInfo = WALNode.this.checkpointManager.getOldestMemTableInfo();
            if (oldestMemTableInfo == null) {
                return false;
            }
            IMemTable oldestMemTable = oldestMemTableInfo.getMemTable();
            File oldestTsFile = FSFactoryProducer.getFSFactory().getFile(oldestMemTableInfo.getTsFilePath());
            try {
                dataRegion = StorageEngineV2.getInstance().getDataRegion(new DataRegionId(TsFileUtils.getDataRegionId((File)oldestTsFile)));
            }
            catch (Exception e) {
                logger.error("Fail to get data region processor for {}", (Object)oldestTsFile, (Object)e);
                return false;
            }
            int snapshotCount = WALNode.this.memTableSnapshotCount.getOrDefault(oldestMemTable.getMemTableId(), 0);
            if (TsFileUtils.getTimePartition((File)new File(oldestMemTableInfo.getTsFilePath())) < dataRegion.getLatestTimePartition() || snapshotCount >= config.getMaxWalMemTableSnapshotNum() || oldestMemTable.getTVListsRamCost() > config.getWalMemTableSnapshotThreshold()) {
                this.flushMemTable(dataRegion, oldestTsFile, oldestMemTable);
            } else {
                this.snapshotMemTable(dataRegion, oldestTsFile, oldestMemTableInfo);
            }
            return true;
        }

        private void flushMemTable(DataRegion dataRegion, File tsFile, IMemTable memTable) {
            boolean submitted = true;
            if (memTable.getFlushStatus() == FlushStatus.WORKING) {
                submitted = dataRegion.submitAFlushTask(TsFileUtils.getTimePartition((File)tsFile), TsFileUtils.isSequence((File)tsFile), memTable);
                logger.info("WAL node-{} flushes memTable-{} to TsFile {}, memTable size is {}.", new Object[]{WALNode.this.identifier, memTable.getMemTableId(), tsFile, memTable.getTVListsRamCost()});
            }
            if (submitted || memTable.getFlushStatus() == FlushStatus.FLUSHING) {
                long sleepTime = 0L;
                while (memTable.getFlushStatus() != FlushStatus.FLUSHED) {
                    try {
                        Thread.sleep(1000L);
                        if ((sleepTime += 1000L) <= 10000L) continue;
                        logger.warn("Waiting too long for memTable flush to be done.");
                        break;
                    }
                    catch (InterruptedException e) {
                        logger.warn("Interrupted when waiting for memTable flush to be done.");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void snapshotMemTable(DataRegion dataRegion, File tsFile, MemTableInfo memTableInfo) {
            IMemTable memTable = memTableInfo.getMemTable();
            dataRegion.writeLock("CheckpointManager$DeleteOutdatedFileTask.snapshotOrFlushOldestMemTable");
            IMemTable iMemTable = memTable;
            synchronized (iMemTable) {
                if (memTable.getFlushStatus() != FlushStatus.WORKING) {
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 10] lbl7 : MonitorExitStatement: MONITOREXIT : var5_5
                    dataRegion.writeUnlock();
                    return;
                }
                WALNode.this.memTableSnapshotCount.compute(memTable.getMemTableId(), (k, v) -> v == null ? 1 : v + 1);
            }
            {
                WALSignalEntry rollWALFileSignal = new WALSignalEntry(WALEntryType.ROLL_WAL_LOG_WRITER_SIGNAL, true);
                WALFlushListener fileRolledListener = WALNode.this.log(rollWALFileSignal);
                if (fileRolledListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                    logger.error("Fail to roll wal log writer.", (Throwable)fileRolledListener.getCause());
                    // MONITOREXIT @DISABLED, blocks:[5, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                    dataRegion.writeUnlock();
                    return;
                }
                try {
                    memTableInfo.setFirstFileVersionId(WALNode.this.buffer.getCurrentWALFileVersion());
                    WALInfoEntry walEntry = new WALInfoEntry(memTable.getMemTableId(), memTable, true);
                    WALFlushListener flushListener = WALNode.this.log(walEntry);
                    if (flushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                        logger.error("Fail to snapshot memTable of {}", (Object)tsFile, (Object)flushListener.getCause());
                    }
                    logger.info("WAL node-{} snapshots memTable-{} to wal files, memTable size is {}.", new Object[]{WALNode.this.identifier, memTable.getMemTableId(), memTable.getTVListsRamCost()});
                    return;
                }
                finally {
                    dataRegion.writeUnlock();
                }
            }
        }
    }
}

