/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.pipedata.load;

import java.io.File;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.sync.PipeDataLoadException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.sync.pipedata.load.ILoader;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileLoader
implements ILoader {
    private static final Logger logger = LoggerFactory.getLogger(TsFileLoader.class);
    private final File tsFile;
    private final String database;

    public TsFileLoader(File tsFile, String database) {
        this.tsFile = tsFile;
        this.database = database;
    }

    @Override
    public void load() throws PipeDataLoadException {
        try {
            LoadTsFileStatement statement = new LoadTsFileStatement(this.tsFile.getAbsolutePath());
            statement.setDeleteAfterLoad(true);
            statement.setSgLevel(this.parseSgLevel());
            statement.setVerifySchema(true);
            statement.setAutoCreateDatabase(false);
            long queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().execute(statement, queryId, null, "", PARTITION_FETCHER, SCHEMA_FETCHER, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                logger.error(String.format("Load TsFile %s error, statement: %s.", this.tsFile.getPath(), statement));
                logger.error(String.format("Load TsFile result status : %s.", result.status));
                throw new LoadFileException(String.format("Can not execute load TsFile statement: %s", statement));
            }
        }
        catch (Exception e) {
            throw new PipeDataLoadException(e.getMessage());
        }
    }

    private int parseSgLevel() throws IllegalPathException {
        return new PartialPath(this.database).getNodeLength() - 1;
    }
}

