/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Operation;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.OperationType;
import org.apache.iotdb.db.metadata.template.TemplateQueryType;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ClusterSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandalonePartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.StandaloneSchemaFetcher;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.SetStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.db.service.basic.BasicOpenSessionResp;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.thrift.impl.IClientRPCServiceWithHandler;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSyncIdentityInfo;
import org.apache.iotdb.service.rpc.thrift.TSyncTransportMetaInfo;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRPCServiceImpl
implements IClientRPCServiceWithHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientRPCServiceImpl.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher PARTITION_FETCHER;
    private final ISchemaFetcher SCHEMA_FETCHER;
    private static final SelectResult SELECT_RESULT = (resp, queryExecution, fetchSize) -> {
        Pair<List<ByteBuffer>, Boolean> pair = QueryDataSetUtils.convertQueryResultByFetchSize(queryExecution, fetchSize);
        resp.setQueryResult((List)pair.left);
        return (Boolean)pair.right;
    };
    private static final SelectResult OLD_SELECT_RESULT = (resp, queryExecution, fetchSize) -> {
        Pair<TSQueryDataSet, Boolean> pair = QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, fetchSize);
        resp.setQueryDataSet((TSQueryDataSet)pair.left);
        return (Boolean)pair.right;
    };

    public ClientRPCServiceImpl() {
        if (config.isClusterMode()) {
            this.PARTITION_FETCHER = ClusterPartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = ClusterSchemaFetcher.getInstance();
        } else {
            this.PARTITION_FETCHER = StandalonePartitionFetcher.getInstance();
            this.SCHEMA_FETCHER = StandaloneSchemaFetcher.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp executeStatementInternal(TSExecuteStatementReq req, SelectResult setResult) {
        boolean finished = false;
        long queryId = Long.MIN_VALUE;
        String statement = req.getStatement();
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(statement, SESSION_MANAGER.getCurrSession().getZoneId());
            if (s == null) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)"This operation type is not supported"));
                return tSExecuteStatementResp;
            }
            TSStatus status = AuthorityChecker.checkAuthority(s, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return tSExecuteStatementResp;
            }
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Query: {}", (Object)req.sessionId, (Object)statement);
            queryId = SESSION_MANAGER.requestQueryId(SESSION_MANAGER.getCurrSession(), req.statementId);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), statement, this.PARTITION_FETCHER, this.SCHEMA_FETCHER, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                return tSExecuteStatementResp;
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution != null && queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    finished = setResult.apply(resp, queryExecution, req.fetchSize);
                    resp.setMoreData(!finished);
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            if (finished) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp executeRawDataQueryInternal(TSRawDataQueryReq req, SelectResult setResult) {
        boolean finished = false;
        long queryId = Long.MIN_VALUE;
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(req, SESSION_MANAGER.getCurrSession().getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return tSExecuteStatementResp;
            }
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Raw Data Query: {}", (Object)req.sessionId, (Object)req);
            queryId = SESSION_MANAGER.requestQueryId(SESSION_MANAGER.getCurrSession(), req.statementId);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException("error code: " + result.status);
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    finished = setResult.apply(resp, queryExecution, req.fetchSize);
                    resp.setMoreData(!finished);
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_RAW_DATA_QUERY)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            if (finished) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp executeLastDataQueryInternal(TSLastDataQueryReq req, SelectResult setResult) {
        boolean finished = false;
        long queryId = Long.MIN_VALUE;
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)this.getNotLoggedInStatus());
        }
        long startTime = System.currentTimeMillis();
        try {
            Statement s = StatementGenerator.createStatement(req, SESSION_MANAGER.getCurrSession().getZoneId());
            TSStatus status = AuthorityChecker.checkAuthority(s, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
                return tSExecuteStatementResp;
            }
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Last Data Query: {}", (Object)req.sessionId, (Object)req);
            queryId = SESSION_MANAGER.requestQueryId(SESSION_MANAGER.getCurrSession(), req.statementId);
            ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER, req.getTimeout());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException("error code: " + result.status);
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(result.queryId.getId());
            try {
                TSExecuteStatementResp resp;
                if (queryExecution.isQuery()) {
                    resp = this.createResponse(queryExecution.getDatasetHeader(), queryId);
                    resp.setStatus(result.status);
                    finished = setResult.apply(resp, queryExecution, req.fetchSize);
                    resp.setMoreData(!finished);
                } else {
                    resp = RpcUtils.getTSExecuteStatementResp((TSStatus)result.status);
                }
                TSExecuteStatementResp tSExecuteStatementResp = resp;
                threadName.close();
                return tSExecuteStatementResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatus)ErrorHandlingUtils.onQueryException(e, "\"" + req + "\". " + (Object)((Object)OperationType.EXECUTE_LAST_DATA_QUERY)));
                    return tSExecuteStatementResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            if (finished) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
        }
    }

    public TSExecuteStatementResp executeQueryStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementV2(req);
    }

    public TSExecuteStatementResp executeUpdateStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementV2(req);
    }

    public TSExecuteStatementResp executeStatementV2(TSExecuteStatementReq req) {
        return this.executeStatementInternal(req, SELECT_RESULT);
    }

    public TSExecuteStatementResp executeRawDataQueryV2(TSRawDataQueryReq req) {
        return this.executeRawDataQueryInternal(req, SELECT_RESULT);
    }

    public TSExecuteStatementResp executeLastDataQueryV2(TSLastDataQueryReq req) {
        return this.executeLastDataQueryInternal(req, SELECT_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSFetchResultsResp fetchResultsV2(TSFetchResultsReq req) {
        long startTime = System.currentTimeMillis();
        boolean finished = false;
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)this.getNotLoggedInStatus());
                return tSFetchResultsResp;
            }
            TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(req.queryId);
            if (queryExecution == null) {
                resp.setHasResultSet(false);
                resp.setMoreData(false);
                TSFetchResultsResp tSFetchResultsResp = resp;
                return tSFetchResultsResp;
            }
            SetThreadName queryName = new SetThreadName(queryExecution.getQueryId());
            try {
                Pair<List<ByteBuffer>, Boolean> pair = QueryDataSetUtils.convertQueryResultByFetchSize(queryExecution, req.fetchSize);
                List result = (List)pair.left;
                finished = (Boolean)pair.right;
                boolean hasResultSet = result.size() != 0;
                resp.setHasResultSet(hasResultSet);
                resp.setIsAlign(true);
                resp.setQueryResult(result);
                resp.setMoreData(!finished);
                TSFetchResultsResp tSFetchResultsResp = resp;
                queryName.close();
                return tSFetchResultsResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        queryName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.FETCH_RESULTS));
                    return tSFetchResultsResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            if (finished) {
                COORDINATOR.cleanupQueryExecution(req.queryId);
            }
        }
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        IoTDBConstant.ClientVersion clientVersion = this.parseClientVersion(req);
        BasicOpenSessionResp openSessionResp = SESSION_MANAGER.login(SESSION_MANAGER.getCurrSession(), req.username, req.password, req.zoneId, req.client_protocol, clientVersion);
        TSStatus tsStatus = RpcUtils.getStatus((int)openSessionResp.getCode(), (String)openSessionResp.getMessage());
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, ServiceProvider.CURRENT_RPC_VERSION);
        return resp.setSessionId(openSessionResp.getSessionId());
    }

    private IoTDBConstant.ClientVersion parseClientVersion(TSOpenSessionReq req) {
        Map configuration = req.configuration;
        if (configuration != null && configuration.containsKey("version")) {
            return IoTDBConstant.ClientVersion.valueOf((String)((String)configuration.get("version")));
        }
        return IoTDBConstant.ClientVersion.V_0_12;
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        return new TSStatus(!SESSION_MANAGER.closeSession(SESSION_MANAGER.getCurrSession(), COORDINATOR::cleanupQueryExecution) ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        return SESSION_MANAGER.closeOperation(SESSION_MANAGER.getCurrSession(), req.queryId, req.statementId, req.isSetStatementId(), req.isSetQueryId(), COORDINATOR::cleanupQueryExecution);
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        try {
            ZoneId zoneId = SESSION_MANAGER.getCurrSession().getZoneId();
            return new TSGetTimeZoneResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS), zoneId != null ? zoneId.toString() : "Unknown time zone");
        }
        catch (Exception e) {
            return new TSGetTimeZoneResp(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.GET_TIME_ZONE, TSStatusCode.GENERATE_TIME_ZONE_ERROR), "Unknown time zone");
        }
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        try {
            SESSION_MANAGER.getCurrSession().setZoneId(ZoneId.of(req.timeZone));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_TIME_ZONE, TSStatusCode.SET_TIME_ZONE_ERROR);
        }
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        properties.setBuildInfo(IoTDBConstant.BUILD_INFO);
        LOGGER.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        properties.setMaxConcurrentClientNum(IoTDBDescriptor.getInstance().getConfig().getRpcMaxConcurrentClientNum());
        properties.setWatermarkSecretKey(IoTDBDescriptor.getInstance().getConfig().getWatermarkSecretKey());
        properties.setWatermarkBitString(IoTDBDescriptor.getInstance().getConfig().getWatermarkBitString());
        properties.setWatermarkParamMarkRate(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMarkRate());
        properties.setWatermarkParamMaxRightBit(IoTDBDescriptor.getInstance().getConfig().getWatermarkParamMaxRightBit());
        properties.setIsReadOnly(CommonDescriptor.getInstance().getConfig().isReadOnly());
        properties.setThriftMaxFrameSize(IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize());
        return properties;
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        try {
            SetStorageGroupStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create database {}", (Object)SESSION_MANAGER.getCurrSession(), (Object)storageGroup);
            }
            if ((status = AuthorityChecker.checkAuthority(statement = (SetStorageGroupStatement)StatementGenerator.createStatement(storageGroup), SESSION_MANAGER.getCurrSession())).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.SET_STORAGE_GROUP, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.SET_STORAGE_GROUP, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create timeseries {}", (Object)SESSION_MANAGER.getCurrSession(), (Object)req.getPath());
            }
            PathUtils.isLegalSingleMeasurements(Collections.singletonList(req.getMeasurementAlias()));
            CreateTimeSeriesStatement statement = (CreateTimeSeriesStatement)StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create aligned timeseries {}.{}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getPrefixPath(), req.getMeasurements()});
            }
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurementAlias());
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            CreateAlignedTimeSeriesStatement statement = (CreateAlignedTimeSeriesStatement)StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_ALIGNED_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_ALIGNED_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create {} timeseries, the first is {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getPaths().size(), req.getPaths().get(0)});
            }
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurementAliasList());
            CreateMultiTimeSeriesStatement statement = (CreateMultiTimeSeriesStatement)StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_MULTI_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_MULTI_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteTimeseries(long sessionId, List<String> path) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            DeleteTimeSeriesStatement statement = StatementGenerator.createDeleteTimeSeriesStatement(path);
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_TIMESERIES, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_TIMESERIES, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        try {
            DeleteStorageGroupStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} delete {} databases, the first is {}", new Object[]{SESSION_MANAGER.getCurrSession(), storageGroups.size(), storageGroups.get(0)});
            }
            if ((status = AuthorityChecker.checkAuthority(statement = (DeleteStorageGroupStatement)StatementGenerator.createStatement(storageGroups), SESSION_MANAGER.getCurrSession())).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_STORAGE_GROUPS, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_STORAGE_GROUPS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        throw new UnsupportedOperationException();
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        return this.executeStatementInternal(req, OLD_SELECT_RESULT);
    }

    public TSStatus executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        ArrayList<TSStatus> results = new ArrayList<TSStatus>();
        boolean isAllSuccessful = true;
        if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
            return this.getNotLoggedInStatus();
        }
        for (int i = 0; i < req.getStatements().size(); ++i) {
            TSStatus status;
            String statement = (String)req.getStatements().get(i);
            try {
                Statement s = StatementGenerator.createStatement(statement, SESSION_MANAGER.getCurrSession().getZoneId());
                if (s == null) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"This operation type is not supported");
                }
                status = AuthorityChecker.checkAuthority(s, SESSION_MANAGER.getCurrSession());
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return status;
                }
                ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
                ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Query: {}", (Object)req.sessionId, (Object)s);
                long queryId = SESSION_MANAGER.requestQueryId();
                long t2 = System.currentTimeMillis();
                ExecutionResult result = COORDINATOR.execute(s, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), statement, this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
                this.addOperationLatency(Operation.EXECUTE_ONE_SQL_IN_BATCH, t2);
                results.add(result.status);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred when executing executeBatchStatement: ", (Throwable)e);
                status = ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_BATCH_STATEMENT));
                if (status.getCode() != TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()) {
                    isAllSuccessful = false;
                }
                results.add(status);
            }
        }
        this.addOperationLatency(Operation.EXECUTE_JDBC_BATCH, t1);
        return isAllSuccessful ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute batch statements successfully") : RpcUtils.getStatus(results);
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        return this.executeStatement(req);
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        return this.executeStatement(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        boolean finished = false;
        long startTime = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)this.getNotLoggedInStatus());
                return tSFetchResultsResp;
            }
            TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(req.queryId);
            if (queryExecution == null) {
                resp.setHasResultSet(false);
                resp.setMoreData(true);
                TSFetchResultsResp tSFetchResultsResp = resp;
                return tSFetchResultsResp;
            }
            SetThreadName queryName = new SetThreadName(queryExecution.getQueryId());
            try {
                Pair<TSQueryDataSet, Boolean> pair = QueryDataSetUtils.convertTsBlockByFetchSize(queryExecution, req.fetchSize);
                TSQueryDataSet result = (TSQueryDataSet)pair.left;
                finished = (Boolean)pair.right;
                boolean hasResultSet = result.bufferForTime().limit() != 0;
                resp.setHasResultSet(hasResultSet);
                resp.setQueryDataSet(result);
                resp.setIsAlign(true);
                resp.setMoreData(finished);
                TSFetchResultsResp tSFetchResultsResp = resp;
                queryName.close();
                return tSFetchResultsResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        queryName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    finished = true;
                    TSFetchResultsResp tSFetchResultsResp = RpcUtils.getTSFetchResultsResp((TSStatus)ErrorHandlingUtils.onQueryException(e, OperationType.FETCH_RESULTS));
                    return tSFetchResultsResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            if (finished) {
                COORDINATOR.cleanupQueryExecution(req.queryId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecords(TSInsertRecordsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.prefixPaths.get(0), req.getTimestamps().get(0)});
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertRowsStatement statement = (InsertRowsStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORDS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORDS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, device {}, first time {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.prefixPath, req.getTimestamps().get(0)});
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertRowsOfOneDeviceStatement statement = (InsertRowsOfOneDeviceStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORDS_OF_ONE_DEVICE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORDS_OF_ONE_DEVICE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, device {}, first time {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.prefixPath, req.getTimestamps().get(0)});
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertRowsOfOneDeviceStatement statement = (InsertRowsOfOneDeviceStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS_OF_ONE_DEVICE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertRecord(TSInsertRecordReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecord, device {}, time {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getPrefixPath(), req.getTimestamp()});
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            InsertRowStatement statement = (InsertRowStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_RECORD, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablets(TSInsertTabletsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertMultiTabletsStatement statement = (InsertMultiTabletsStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLETS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLETS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablet(TSInsertTabletReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            InsertTabletStatement statement = (InsertTabletStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_TABLET, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_TABLET, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecords(TSInsertStringRecordsReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.prefixPaths.get(0), req.getTimestamps().get(0)});
            }
            PathUtils.isLegalSingleMeasurementLists((List)req.getMeasurementsList());
            InsertRowsStatement statement = (InsertRowsStatement)StatementGenerator.createStatement(req);
            if (statement.isEmpty()) {
                TSStatus tSStatus3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                return tSStatus3;
            }
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus4 = status;
                return tSStatus4;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus5 = result.status;
            return tSStatus5;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORDS, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORDS, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    public TSStatus testInsertTablet(TSInsertTabletReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertTablets(TSInsertTabletsReq req) {
        LOGGER.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        LOGGER.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecord(TSInsertStringRecordReq req) {
        LOGGER.debug("Test insert string record request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecords(TSInsertRecordsReq req) {
        LOGGER.debug("Test insert row in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) {
        LOGGER.debug("Test insert rows in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecords(TSInsertStringRecordsReq req) {
        LOGGER.debug("Test insert string records request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus deleteData(TSDeleteDataReq req) {
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            DeleteDataStatement statement = StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.DELETE_DATA, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.DELETE_DATA, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req) {
        return this.executeRawDataQueryInternal(req, OLD_SELECT_RESULT);
    }

    public TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req) {
        return this.executeLastDataQueryInternal(req, OLD_SELECT_RESULT);
    }

    public long requestStatementId(long sessionId) {
        return SESSION_MANAGER.requestStatementId(SESSION_MANAGER.getCurrSession());
    }

    public TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req) {
        try {
            CreateSchemaTemplateStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} create schema template {}", (Object)SESSION_MANAGER.getCurrSession(), (Object)req.getName());
            }
            if ((status = AuthorityChecker.checkAuthority(statement = StatementGenerator.createStatement(req), SESSION_MANAGER.getCurrSession())).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IoTDBException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.CREATE_SCHEMA_TEMPLATE, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.CREATE_SCHEMA_TEMPLATE, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req) {
        throw new UnsupportedOperationException();
    }

    public TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req) {
        throw new UnsupportedOperationException();
    }

    public TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req) {
        TSQueryTemplateResp resp = new TSQueryTemplateResp();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                resp.setStatus(this.getNotLoggedInStatus());
                return resp;
            }
            Statement statement = StatementGenerator.createStatement(req);
            if (statement == null) {
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNSUPPORTED_OPERATION, (String)(TemplateQueryType.values()[req.getQueryType()].name() + "has not been supported.")));
                return resp;
            }
            switch (TemplateQueryType.values()[req.getQueryType()]) {
                case SHOW_MEASUREMENTS: {
                    resp.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
                    break;
                }
                case SHOW_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_TEMPLATES.ordinal());
                    break;
                }
                case SHOW_SET_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_SET_TEMPLATES.ordinal());
                    break;
                }
                case SHOW_USING_TEMPLATES: {
                    resp.setQueryType(TemplateQueryType.SHOW_USING_TEMPLATES.ordinal());
                }
            }
            return this.executeTemplateQueryStatement(statement, req, resp);
        }
        catch (Exception e) {
            resp.setStatus(ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_QUERY_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR));
            return resp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSQueryTemplateResp executeTemplateQueryStatement(Statement statement, TSQueryTemplateReq req, TSQueryTemplateResp resp) {
        long startTime = System.currentTimeMillis();
        try {
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            ServiceProvider.QUERY_FREQUENCY_RECORDER.incrementAndGet();
            ServiceProvider.AUDIT_LOGGER.debug("Session {} execute Query: {}", (Object)req.sessionId, (Object)statement);
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult executionResult = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), null, this.PARTITION_FETCHER, this.SCHEMA_FETCHER, config.getQueryTimeoutThreshold());
            if (executionResult.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && executionResult.status.code != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                resp.setStatus(executionResult.status);
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                return tSQueryTemplateResp;
            }
            IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
            SetThreadName threadName = new SetThreadName(executionResult.queryId.getId());
            try {
                ArrayList<String> result = new ArrayList<String>();
                while (queryExecution.hasNextResult()) {
                    Optional<TsBlock> tsBlock;
                    try {
                        tsBlock = queryExecution.getBatchResult();
                    }
                    catch (IoTDBException e) {
                        throw new RuntimeException("Fetch Schema failed. ", e);
                    }
                    if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                    Column column = tsBlock.get().getColumn(0);
                    for (int i = 0; i < column.getPositionCount(); ++i) {
                        result.add(column.getBinary(i).getStringValue());
                    }
                }
                resp.setMeasurements(result);
                resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully"));
                TSQueryTemplateResp tSQueryTemplateResp = resp;
                threadName.close();
                return tSQueryTemplateResp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    resp.setStatus(ErrorHandlingUtils.onQueryException(e, "\"" + statement + "\". " + (Object)((Object)OperationType.EXECUTE_STATEMENT)));
                    TSQueryTemplateResp tSQueryTemplateResp = null;
                    return tSQueryTemplateResp;
                }
            }
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
        }
    }

    public TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req) throws TException {
        try {
            SetSchemaTemplateStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} set schema template {}.{}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getTemplateName(), req.getPrefixPath()});
            }
            if ((status = AuthorityChecker.checkAuthority(statement = StatementGenerator.createStatement(req), SESSION_MANAGER.getCurrSession())).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IllegalPathException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req) throws TException {
        try {
            UnsetSchemaTemplateStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} unset schema template {} from {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getTemplateName(), req.getPrefixPath()});
            }
            if ((status = AuthorityChecker.checkAuthority(statement = StatementGenerator.createStatement(req), SESSION_MANAGER.getCurrSession())).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (IllegalPathException e) {
            return ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.EXECUTE_STATEMENT, e.getErrorCode());
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req) throws TException {
        try {
            DropSchemaTemplateStatement statement;
            TSStatus status;
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                return this.getNotLoggedInStatus();
            }
            if (ServiceProvider.AUDIT_LOGGER.isDebugEnabled()) {
                ServiceProvider.AUDIT_LOGGER.debug("Session-{} drop schema template {}", (Object)SESSION_MANAGER.getCurrSession(), (Object)req.getTemplateName());
            }
            if ((status = AuthorityChecker.checkAuthority(statement = StatementGenerator.createStatement(req), SESSION_MANAGER.getCurrSession())).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            return result.status;
        }
        catch (Exception e) {
            return ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.EXECUTE_STATEMENT, TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus handshake(TSyncIdentityInfo info) throws TException {
        return SyncService.getInstance().handshake(info, SESSION_MANAGER.getCurrSession().getClientAddress(), this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
    }

    public TSStatus sendPipeData(ByteBuffer buff) throws TException {
        return SyncService.getInstance().transportPipeData(buff);
    }

    public TSStatus sendFile(TSyncTransportMetaInfo metaInfo, ByteBuffer buff) throws TException {
        return SyncService.getInstance().transportFile(metaInfo, buff);
    }

    public TSConnectionInfoResp fetchAllConnectionsInfo() throws TException {
        return SESSION_MANAGER.getAllConnectionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertStringRecord(TSInsertStringRecordReq req) {
        TSStatus tSStatus;
        long t1 = System.currentTimeMillis();
        try {
            if (!SESSION_MANAGER.checkLogin(SESSION_MANAGER.getCurrSession())) {
                TSStatus tSStatus2 = this.getNotLoggedInStatus();
                return tSStatus2;
            }
            ServiceProvider.AUDIT_LOGGER.debug("Session {} insertRecord, device {}, time {}", new Object[]{SESSION_MANAGER.getCurrSession(), req.getPrefixPath(), req.getTimestamp()});
            PathUtils.isLegalSingleMeasurements((List)req.getMeasurements());
            InsertRowStatement statement = (InsertRowStatement)StatementGenerator.createStatement(req);
            TSStatus status = AuthorityChecker.checkAuthority(statement, SESSION_MANAGER.getCurrSession());
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus3 = status;
                return tSStatus3;
            }
            long queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.execute(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.PARTITION_FETCHER, this.SCHEMA_FETCHER);
            TSStatus tSStatus4 = result.status;
            return tSStatus4;
        }
        catch (IoTDBException e) {
            tSStatus = ErrorHandlingUtils.onIoTDBException((Exception)((Object)e), OperationType.INSERT_STRING_RECORD, e.getErrorCode());
            return tSStatus;
        }
        catch (Exception e) {
            tSStatus = ErrorHandlingUtils.onNPEOrUnexpectedException(e, OperationType.INSERT_STRING_RECORD, TSStatusCode.EXECUTE_STATEMENT_ERROR);
            return tSStatus;
        }
        finally {
            this.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    private TSExecuteStatementResp createResponse(DatasetHeader header, long queryId) {
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        resp.setColumnNameIndexMap(header.getColumnNameIndexMap());
        resp.setSgColumns(new ArrayList());
        resp.setColumns(header.getRespColumns());
        resp.setDataTypeList(header.getRespDataTypeList());
        resp.setAliasColumns(header.getRespAliasColumns());
        resp.setIgnoreTimeStamp(header.isIgnoreTimestamp());
        resp.setQueryId(queryId);
        return resp;
    }

    private TSStatus getNotLoggedInStatus() {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN, (String)"Log in failed. Either you are not authorized or the session has timed out.");
    }

    private void addOperationLatency(Operation operation, long startTime) {
        MetricService.getInstance().histogram(System.currentTimeMillis() - startTime, Metric.OPERATION.toString(), MetricLevel.IMPORTANT, new String[]{"name", operation.getName()});
    }

    @Override
    public void handleClientExit() {
        IClientSession session = SESSION_MANAGER.getCurrSession();
        if (session != null) {
            TSCloseSessionReq req = new TSCloseSessionReq();
            this.closeSession(req);
        }
        SyncService.getInstance().handleClientExit();
    }

    @FunctionalInterface
    public static interface SelectResult {
        public boolean apply(TSExecuteStatementResp var1, IQueryExecution var2, int var3) throws IoTDBException, IOException;
    }
}

