/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(SystemMetrics.class);
    private OperatingSystemMXBean osMXBean;
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private final Set<FileStore> fileStores = new HashSet<FileStore>();
    private boolean isDataNode = false;
    private long systemDiskTotalSpace = 0L;
    private long systemDiskFreeSpace = 0L;

    public SystemMetrics(boolean isDataNode) {
        this.isDataNode = isDataNode;
        this.osMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    public void bindTo(AbstractMetricService metricService) {
        this.collectSystemCpuInfo(metricService);
        this.collectSystemMemInfo(metricService);
        if (null == this.currentServiceFuture && this.isDataNode) {
            this.collectSystemDiskInfo(metricService);
            this.currentServiceFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.service, this::collectDiskMetrics, (long)1L, (long)MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        if (this.currentServiceFuture != null && this.isDataNode) {
            this.currentServiceFuture.cancel(true);
            this.currentServiceFuture = null;
        }
        this.removeSystemCpuInfo(metricService);
        if (this.isDataNode) {
            this.removeSystemDiskInfo(metricService);
        }
        this.removeSystemMemInfo(metricService);
    }

    private void collectSystemCpuInfo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.SYS_CPU_LOAD.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> (long)(this.osMXBean.getSystemCpuLoad() * 100.0), new String[]{Tag.NAME.toString(), "system"});
        metricService.getOrCreateGauge(Metric.SYS_CPU_CORES.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "system"}).set((long)this.osMXBean.getAvailableProcessors());
    }

    private void removeSystemCpuInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SYS_CPU_LOAD.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.GAUGE, Metric.SYS_CPU_CORES.toString(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void collectSystemMemInfo(AbstractMetricService metricService) {
        metricService.getOrCreateGauge(Metric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), "system"}).set(this.osMXBean.getTotalPhysicalMemorySize());
        metricService.createAutoGauge(Metric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getFreePhysicalMemorySize(), new String[]{Tag.NAME.toString(), "system"});
        metricService.createAutoGauge(Metric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getTotalSwapSpaceSize(), new String[]{Tag.NAME.toString(), "system"});
        metricService.createAutoGauge(Metric.SYS_FREE_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getFreeSwapSpaceSize(), new String[]{Tag.NAME.toString(), "system"});
        metricService.createAutoGauge(Metric.SYS_COMMITTED_VM_SIZE.toString(), MetricLevel.CORE, (Object)this.osMXBean, a -> this.osMXBean.getCommittedVirtualMemorySize(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void removeSystemMemInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SYS_FREE_SWAP_SPACE_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SYS_COMMITTED_VM_SIZE.toString(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void collectSystemDiskInfo(AbstractMetricService metricService) {
        String[] dataDirs;
        for (String dataDir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
            Path path = Paths.get(dataDir, new String[0]);
            FileStore fileStore = null;
            try {
                fileStore = Files.getFileStore(path);
            }
            catch (IOException e) {
                path = path.getParent();
                try {
                    fileStore = Files.getFileStore(path);
                }
                catch (IOException innerException) {
                    logger.error("Failed to get storage path of {}, because", (Object)dataDir, (Object)innerException);
                }
            }
            if (null == fileStore) continue;
            this.fileStores.add(fileStore);
        }
        metricService.createAutoGaugeWithInternalReport(Metric.SYS_DISK_TOTAL_SPACE.toString(), MetricLevel.CORE, (Object)this, SystemMetrics::getSystemDiskTotalSpace, new String[]{Tag.NAME.toString(), "system"});
        metricService.createAutoGaugeWithInternalReport(Metric.SYS_DISK_FREE_SPACE.toString(), MetricLevel.CORE, (Object)this, SystemMetrics::getSystemDiskFreeSpace, new String[]{Tag.NAME.toString(), "system"});
    }

    private void removeSystemDiskInfo(AbstractMetricService metricService) {
        this.fileStores.clear();
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SYS_DISK_TOTAL_SPACE.toString(), new String[]{Tag.NAME.toString(), "system"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SYS_DISK_FREE_SPACE.toString(), new String[]{Tag.NAME.toString(), "system"});
    }

    private void collectDiskMetrics() {
        long sysTotalSpace = 0L;
        long sysFreeSpace = 0L;
        for (FileStore fileStore : this.fileStores) {
            try {
                sysTotalSpace += fileStore.getTotalSpace();
                sysFreeSpace += fileStore.getUsableSpace();
            }
            catch (IOException e) {
                logger.error("Failed to statistic the size of {}, because", (Object)fileStore, (Object)e);
            }
        }
        this.systemDiskTotalSpace = sysTotalSpace;
        this.systemDiskFreeSpace = sysFreeSpace;
    }

    public long getSystemDiskTotalSpace() {
        return this.systemDiskTotalSpace;
    }

    public void setSystemDiskTotalSpace(long systemDiskTotalSpace) {
        this.systemDiskTotalSpace = systemDiskTotalSpace;
    }

    public long getSystemDiskFreeSpace() {
        return this.systemDiskFreeSpace;
    }

    public void setSystemDiskFreeSpace(long systemDiskFreeSpace) {
        this.systemDiskFreeSpace = systemDiskFreeSpace;
    }
}

