/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.builder.DAGBuilder;
import org.apache.iotdb.db.mpp.transformation.dag.input.IUDFInputDataSet;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public abstract class UDTFDataSet
extends QueryDataSet {
    protected static final float UDF_READER_MEMORY_BUDGET_IN_MB = IoTDBDescriptor.getInstance().getConfig().getUdfReaderMemoryBudgetInMB();
    protected static final float UDF_TRANSFORMER_MEMORY_BUDGET_IN_MB = IoTDBDescriptor.getInstance().getConfig().getUdfTransformerMemoryBudgetInMB();
    protected static final float UDF_COLLECTOR_MEMORY_BUDGET_IN_MB = IoTDBDescriptor.getInstance().getConfig().getUdfCollectorMemoryBudgetInMB();
    protected final long queryId;
    protected final UDTFPlan udtfPlan;
    protected final QueryDataSetInputLayer queryDataSetInputLayer;
    protected LayerPointReader[] transformers;

    protected UDTFDataSet(QueryContext queryContext, UDTFPlan udtfPlan, List<PartialPath> deduplicatedPaths, List<TSDataType> deduplicatedDataTypes, TimeGenerator timestampGenerator, List<IReaderByTimestamp> readersOfSelectedSeries, List<List<Integer>> readerToIndexList, List<Boolean> cached) throws QueryProcessException, IOException {
        super(new ArrayList<PartialPath>(deduplicatedPaths), deduplicatedDataTypes);
        this.queryId = queryContext.getQueryId();
        this.udtfPlan = udtfPlan;
        this.queryDataSetInputLayer = new QueryDataSetInputLayer(this.queryId, UDF_READER_MEMORY_BUDGET_IN_MB, deduplicatedPaths, deduplicatedDataTypes, timestampGenerator, readersOfSelectedSeries, readerToIndexList, cached);
        this.initTransformers();
        this.initDataSetFields();
    }

    protected UDTFDataSet(QueryContext queryContext, UDTFPlan udtfPlan, List<PartialPath> deduplicatedPaths, List<TSDataType> deduplicatedDataTypes, List<ManagedSeriesReader> readersOfSelectedSeries) throws QueryProcessException, IOException, InterruptedException {
        super(new ArrayList<PartialPath>(deduplicatedPaths), deduplicatedDataTypes);
        this.queryId = queryContext.getQueryId();
        this.udtfPlan = udtfPlan;
        this.queryDataSetInputLayer = new QueryDataSetInputLayer(this.queryId, UDF_READER_MEMORY_BUDGET_IN_MB, udtfPlan, readersOfSelectedSeries);
        this.initTransformers();
        this.initDataSetFields();
    }

    public UDTFDataSet(QueryContext queryContext, UDTFPlan udtfPlan, IUDFInputDataSet dataSet) throws QueryProcessException, IOException {
        this.queryId = queryContext.getQueryId();
        this.udtfPlan = udtfPlan;
        this.queryDataSetInputLayer = new QueryDataSetInputLayer(this.queryId, UDF_READER_MEMORY_BUDGET_IN_MB, dataSet);
        this.initTransformers();
        this.initDataSetFields();
    }

    protected void initTransformers() throws QueryProcessException, IOException {
        UDFManagementService.getInstance().acquireLock();
        UDFClassLoaderManager.getInstance().initializeUDFQuery(this.queryId);
        try {
            this.transformers = new DAGBuilder(this.queryId, this.udtfPlan, this.queryDataSetInputLayer, UDF_TRANSFORMER_MEMORY_BUDGET_IN_MB + UDF_COLLECTOR_MEMORY_BUDGET_IN_MB).bindInputLayerColumnIndexWithExpression().buildLayerMemoryAssigner().buildResultColumnPointReaders().setDataSetResultColumnDataTypes().getResultColumnPointReaders();
        }
        finally {
            UDFManagementService.getInstance().releaseLock();
        }
    }

    private void initDataSetFields() {
        this.columnNum = this.udtfPlan.getPathToIndex().size();
    }

    public void finalizeUDFs(long queryId) {
        this.udtfPlan.finalizeUDFExecutors(queryId);
    }
}

