/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.analyze.SchemaValidator;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.mpp.plan.scheduler.FixedRateFragInsStateTracker;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceStateTracker;
import org.apache.iotdb.db.mpp.plan.scheduler.IScheduler;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneScheduler
implements IScheduler {
    private static final StorageEngineV2 STORAGE_ENGINE = StorageEngineV2.getInstance();
    private static final SchemaEngine SCHEMA_ENGINE = SchemaEngine.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneScheduler.class);
    private final MPPQueryContext queryContext;
    private final QueryStateMachine stateMachine;
    private final QueryType queryType;
    private final List<FragmentInstance> instances;
    private final IFragInstanceStateTracker stateTracker;

    public StandaloneScheduler(MPPQueryContext queryContext, QueryStateMachine stateMachine, List<FragmentInstance> instances, QueryType queryType, ScheduledExecutorService scheduledExecutor, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.queryContext = queryContext;
        this.instances = instances;
        this.queryType = queryType;
        this.stateMachine = stateMachine;
        this.stateTracker = new FixedRateFragInsStateTracker(stateMachine, scheduledExecutor, instances, internalServiceClientManager);
    }

    @Override
    public void start() {
        this.stateMachine.transitionToDispatching();
        switch (this.queryType) {
            case READ: {
                try {
                    for (FragmentInstance fragmentInstance : this.instances) {
                        Object region;
                        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)fragmentInstance.getRegionReplicaSet().getRegionId());
                        if (groupId instanceof DataRegionId) {
                            region = StorageEngineV2.getInstance().getDataRegion((DataRegionId)groupId);
                            FragmentInstanceInfo info = FragmentInstanceManager.getInstance().execDataQueryFragmentInstance(fragmentInstance, (DataRegion)region);
                            if (!info.getState().isFailed()) continue;
                            this.stateMachine.transitionToFailed(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)info.getMessage()));
                            return;
                        }
                        region = SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)groupId);
                        FragmentInstanceManager.getInstance().execSchemaQueryFragmentInstance(fragmentInstance, (ISchemaRegion)region);
                    }
                }
                catch (Exception e) {
                    this.stateMachine.transitionToFailed(e);
                    LOGGER.info("transit to FAILED");
                    return;
                }
                this.stateMachine.transitionToRunning();
                LOGGER.info("transit to RUNNING");
                this.stateTracker.start();
                LOGGER.info("state tracker starts");
                break;
            }
            case WRITE: {
                if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
                    TSStatus failedStatus = new TSStatus(TSStatusCode.SYSTEM_READ_ONLY.getStatusCode());
                    failedStatus.setMessage("Fail to do non-query operations because system is read-only.");
                    this.stateMachine.transitionToFailed(failedStatus);
                    return;
                }
                try {
                    for (FragmentInstance fragmentInstance : this.instances) {
                        PlanNode planNode = fragmentInstance.getFragment().getPlanNodeTree();
                        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)fragmentInstance.getRegionReplicaSet().getRegionId());
                        boolean hasFailedMeasurement = false;
                        if (planNode instanceof InsertNode) {
                            InsertNode insertNode = (InsertNode)planNode;
                            SchemaValidator.validate(insertNode);
                            hasFailedMeasurement = insertNode.hasFailedMeasurements();
                            if (hasFailedMeasurement) {
                                LOGGER.warn("Fail to insert measurements {} caused by {}", insertNode.getFailedMeasurements(), insertNode.getFailedMessages());
                            }
                        }
                        TSStatus executionResult = groupId instanceof DataRegionId ? STORAGE_ENGINE.write((DataRegionId)groupId, planNode) : SCHEMA_ENGINE.write((SchemaRegionId)groupId, planNode);
                        if (hasFailedMeasurement) {
                            InsertNode node = (InsertNode)planNode;
                            List<Exception> exceptions = node.getFailedExceptions();
                            throw new WriteProcessException("failed to insert measurements " + node.getFailedMeasurements() + (!exceptions.isEmpty() ? " caused by " + exceptions.get(0).getMessage() : ""));
                        }
                        if (executionResult.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                        LOGGER.error("Execute write operation error: {}", (Object)executionResult.getMessage());
                        this.stateMachine.transitionToFailed(executionResult);
                        return;
                    }
                    this.stateMachine.transitionToFinished();
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Execute write operation error ", (Throwable)e);
                    this.stateMachine.transitionToFailed(e);
                }
            }
        }
    }

    @Override
    public void stop() {
        this.stateTracker.abort();
        for (FragmentInstance fragmentInstance : this.instances) {
            FragmentInstanceManager.getInstance().cancelTask(fragmentInstance.getId());
        }
    }

    @Override
    public Duration getTotalCpuTime() {
        return null;
    }

    @Override
    public FragmentInfo getFragmentInfo() {
        return null;
    }

    @Override
    public void abortFragmentInstance(FragmentInstanceId instanceId, Throwable failureCause) {
    }

    @Override
    public void cancelFragment(PlanFragmentId planFragmentId) {
    }

    private String getLogHeader() {
        return String.format("Query[%s]", this.queryContext.getQueryId());
    }
}

