/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.mpp.execution.operator.process.last.UpdateLastCacheOperator;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.utils.Binary;

public class LastQuerySortOperator
implements ProcessOperator {
    private static final int MAX_DETECT_COUNT = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
    private TsBlock cachedTsBlock;
    private final int cachedTsBlockSize;
    private int cachedTsBlockRowIndex;
    private final List<UpdateLastCacheOperator> children;
    private final OperatorContext operatorContext;
    private final int inputOperatorsCount;
    private int currentIndex;
    private final TsBlockBuilder tsBlockBuilder;
    private final Comparator<Binary> timeSeriesComparator;
    private TsBlock previousTsBlock;

    public LastQuerySortOperator(OperatorContext operatorContext, TsBlock cachedTsBlock, List<UpdateLastCacheOperator> children, Comparator<Binary> timeSeriesComparator) {
        this.cachedTsBlock = cachedTsBlock;
        this.cachedTsBlockSize = cachedTsBlock.getPositionCount();
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.currentIndex = 0;
        this.tsBlockBuilder = LastQueryUtil.createTsBlockBuilder();
        this.timeSeriesComparator = timeSeriesComparator;
        this.previousTsBlock = null;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.currentIndex < this.inputOperatorsCount) {
            int endIndex = this.getEndIndex();
            ArrayList listenableFutures = new ArrayList();
            for (int i = this.currentIndex; i < endIndex; ++i) {
                ListenableFuture<?> blocked = this.children.get(i).isBlocked();
                if (blocked.isDone()) continue;
                listenableFutures.add(blocked);
            }
            return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
        }
        return Futures.immediateVoidFuture();
    }

    @Override
    public TsBlock next() {
        if (this.currentIndex >= this.inputOperatorsCount) {
            while (this.previousTsBlock != null) {
                if (this.canUseDataFromCachedTsBlock(this.previousTsBlock)) {
                    LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.cachedTsBlock, this.cachedTsBlockRowIndex++);
                    continue;
                }
                LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.previousTsBlock, 0);
                this.previousTsBlock = null;
            }
            TsBlock res = this.cachedTsBlock.subTsBlock(this.cachedTsBlockRowIndex);
            this.cachedTsBlockRowIndex = this.cachedTsBlockSize;
            if (!this.tsBlockBuilder.isEmpty()) {
                LastQueryUtil.appendLastValue(this.tsBlockBuilder, res);
                res = this.tsBlockBuilder.build();
                this.tsBlockBuilder.reset();
            }
            return res;
        }
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        int endIndex = this.getEndIndex();
        while (!(System.nanoTime() - start >= maxRuntime || this.currentIndex >= endIndex && this.previousTsBlock == null || this.tsBlockBuilder.isFull())) {
            if (this.previousTsBlock != null) {
                if (this.canUseDataFromCachedTsBlock(this.previousTsBlock)) {
                    LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.cachedTsBlock, this.cachedTsBlockRowIndex++);
                    continue;
                }
                LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.previousTsBlock, 0);
                this.previousTsBlock = null;
                continue;
            }
            if (this.children.get(this.currentIndex).hasNext()) {
                TsBlock tsBlock = this.children.get(this.currentIndex).next();
                if (tsBlock == null) {
                    return null;
                }
                if (!tsBlock.isEmpty()) {
                    if (this.canUseDataFromCachedTsBlock(tsBlock)) {
                        LastQueryUtil.appendLastValue(this.tsBlockBuilder, this.cachedTsBlock, this.cachedTsBlockRowIndex++);
                        this.previousTsBlock = tsBlock;
                    } else {
                        LastQueryUtil.appendLastValue(this.tsBlockBuilder, tsBlock, 0);
                    }
                }
            }
            ++this.currentIndex;
        }
        TsBlock res = this.tsBlockBuilder.build();
        this.tsBlockBuilder.reset();
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.inputOperatorsCount || this.cachedTsBlockRowIndex < this.cachedTsBlockSize || !this.tsBlockBuilder.isEmpty() || this.previousTsBlock != null;
    }

    @Override
    public void close() throws Exception {
        for (Operator operator : this.children) {
            operator.close();
        }
        this.cachedTsBlock = null;
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + this.cachedTsBlock.getRetainedSizeInBytes();
        long res = 0L;
        for (Operator operator : this.children) {
            res = Math.max(res, maxPeekMemory + operator.calculateMaxPeekMemory());
        }
        return res;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long childrenMaxReturnSize = 0L;
        long childrenSumRetainedSize = 0L;
        for (Operator operator : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, operator.calculateMaxReturnSize());
            childrenSumRetainedSize += operator.calculateRetainedSizeAfterCallingNext();
        }
        return this.cachedTsBlock.getRetainedSizeInBytes() + childrenMaxReturnSize + childrenSumRetainedSize;
    }

    private int getEndIndex() {
        return this.currentIndex + Math.min(MAX_DETECT_COUNT, this.inputOperatorsCount - this.currentIndex);
    }

    private boolean canUseDataFromCachedTsBlock(TsBlock tsBlock) {
        return this.cachedTsBlockRowIndex < this.cachedTsBlockSize && LastQueryUtil.compareTimeSeries(this.cachedTsBlock, this.cachedTsBlockRowIndex, tsBlock, 0, this.timeSeriesComparator) < 0;
    }
}

