/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.fragment;

import com.google.common.base.Preconditions;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceFailureInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.query.context.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceContext
extends QueryContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceContext.class);
    private static final long END_TIME_INITIAL_VALUE = -1L;
    private final FragmentInstanceId id;
    private final List<OperatorContext> operatorContexts = new ArrayList<OperatorContext>();
    private DriverContext driverContext;
    private final FragmentInstanceStateMachine stateMachine;
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicReference<Long> executionStartTime = new AtomicReference();
    private final AtomicReference<Long> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<Long> executionEndTime = new AtomicReference();
    private SessionInfo sessionInfo;

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContextForCompaction(long queryId) {
        return new FragmentInstanceContext(queryId);
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
    }

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, new SessionInfo(1L, "test", ZoneId.systemDefault().getId()));
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    private FragmentInstanceContext(long queryId) {
        this.queryId = queryId;
        this.id = null;
        this.stateMachine = null;
    }

    public void start() {
        long now = System.currentTimeMillis();
        this.executionStartTime.compareAndSet(null, now);
        this.startNanos.compareAndSet(0L, System.nanoTime());
        this.lastExecutionStartTime.set(now);
    }

    private void initialize() {
        this.stateMachine.addStateChangeListener(this::updateStatsIfDone);
    }

    private void updateStatsIfDone(FragmentInstanceState newState) {
        if (newState.isDone()) {
            long now = System.currentTimeMillis();
            this.executionStartTime.compareAndSet(null, now);
            this.startNanos.compareAndSet(0L, System.nanoTime());
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.executionEndTime.compareAndSet(-1L, now);
            this.endNanos.compareAndSet(0L, System.nanoTime());
        }
    }

    public OperatorContext addOperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        for (OperatorContext operatorContext : this.operatorContexts) {
            Preconditions.checkArgument((operatorId != operatorContext.getOperatorId() ? 1 : 0) != 0, (String)"A context already exists for operatorId %s", (int)operatorId);
        }
        OperatorContext operatorContext = new OperatorContext(operatorId, planNodeId, operatorType, this);
        this.operatorContexts.add(operatorContext);
        return operatorContext;
    }

    public List<OperatorContext> getOperatorContexts() {
        return this.operatorContexts;
    }

    public FragmentInstanceId getId() {
        return this.id;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public void setDriverContext(DriverContext driverContext) {
        this.driverContext = driverContext;
    }

    public void failed(Throwable cause) {
        this.stateMachine.failed(cause);
    }

    public String getFailedCause() {
        return this.stateMachine.getFailureCauses().stream().findFirst().map(Throwable::getMessage).orElse("");
    }

    public List<FragmentInstanceFailureInfo> getFailureInfoList() {
        return this.stateMachine.getFailureCauses().stream().map(FragmentInstanceFailureInfo::toFragmentInstanceFailureInfo).collect(Collectors.toList());
    }

    public void finished() {
        this.stateMachine.finished();
    }

    public void transitionToFlushing() {
        this.stateMachine.transitionToFlushing();
    }

    public void cancel() {
        this.stateMachine.cancel();
    }

    public void abort() {
        this.stateMachine.abort();
    }

    public long getEndTime() {
        return this.executionEndTime.get();
    }

    @Override
    public long getStartTime() {
        return this.executionStartTime.get();
    }

    public FragmentInstanceInfo getInstanceInfo() {
        return new FragmentInstanceInfo(this.stateMachine.getState(), this.getEndTime(), this.getFailedCause(), this.getFailureInfoList());
    }

    public FragmentInstanceStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public Optional<Throwable> getFailureCause() {
        return Optional.ofNullable(this.stateMachine.getFailureCauses().peek());
    }
}

