/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.template.Template;

public abstract class Traverser {
    protected IMTreeStore store;
    protected IMNode startNode;
    protected String[] nodes;
    protected int startIndex;
    protected int startLevel;
    protected boolean isPrefixStart = false;
    protected Deque<IMNode> traverseContext;
    protected boolean isInTemplate = false;
    protected boolean shouldTraverseTemplate = false;
    protected Map<Integer, Template> templateMap;
    protected boolean skipPreDeletedSchema = false;
    protected boolean isPrefixMatch = false;

    public Traverser(IMNode startNode, PartialPath path, IMTreeStore store) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals("root")) {
            throw new IllegalPathException(path.getFullPath(), path.getFullPath() + " doesn't start with " + startNode.getName());
        }
        this.startNode = startNode;
        this.nodes = nodes;
        this.store = store;
        this.traverseContext = new ArrayDeque<IMNode>();
        this.initStartIndexAndLevel(path);
    }

    private void initStartIndexAndLevel(PartialPath path) throws MetadataException {
        ArrayDeque<IMNode> ancestors = new ArrayDeque<IMNode>();
        ancestors.push(this.startNode);
        this.startLevel = 0;
        for (IMNode parent = this.startNode.getParent(); parent != null; parent = parent.getParent()) {
            ++this.startLevel;
            this.traverseContext.addLast(parent);
            ancestors.push(parent);
        }
        this.startIndex = 0;
        while (this.startIndex <= this.startLevel && this.startIndex < this.nodes.length) {
            IMNode cur = (IMNode)ancestors.pop();
            if (this.nodes[this.startIndex].equals("**")) {
                return;
            }
            if (!this.nodes[this.startIndex].equals(cur.getName()) && !this.nodes[this.startIndex].contains("*")) {
                throw new IllegalPathException(path.getFullPath(), path.getFullPath() + " doesn't start with " + cur.getFullPath());
            }
            ++this.startIndex;
        }
        if (this.startIndex <= this.startLevel) {
            if (!this.nodes[this.startIndex - 1].equals("**")) {
                this.isPrefixStart = true;
            }
        } else {
            --this.startIndex;
        }
    }

    public void traverse() throws MetadataException {
        if (this.isPrefixStart && !this.isPrefixMatch) {
            return;
        }
        this.traverse(this.startNode, this.startIndex, this.startLevel);
    }

    protected void traverse(IMNode node, int idx, int level) throws MetadataException {
        if (this.processMatchedMNode(node, idx, level)) {
            return;
        }
        if (idx >= this.nodes.length - 1) {
            if (this.nodes[this.nodes.length - 1].equals("**") || this.isPrefixMatch) {
                this.processMultiLevelWildcard(node, idx, level);
            }
            return;
        }
        if (node.isMeasurement()) {
            return;
        }
        String targetName = this.nodes[idx + 1];
        if ("**".equals(targetName)) {
            this.processMultiLevelWildcard(node, idx, level);
        } else if (targetName.contains("*")) {
            this.processOneLevelWildcard(node, idx, level);
        } else {
            this.processNameMatch(node, idx, level);
        }
    }

    private boolean processMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (idx < this.nodes.length - 1) {
            return this.processInternalMatchedMNode(node, idx, level);
        }
        return this.processFullMatchedMNode(node, idx, level);
    }

    protected abstract boolean processInternalMatchedMNode(IMNode var1, int var2, int var3) throws MetadataException;

    protected abstract boolean processFullMatchedMNode(IMNode var1, int var2, int var3) throws MetadataException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMultiLevelWildcard(IMNode node, int idx, int level) throws MetadataException {
        if (this.isInTemplate) {
            this.traverseContext.push(node);
            for (IMNode child : node.getChildren().values()) {
                this.traverse(child, idx + 1, level + 1);
            }
            this.traverseContext.pop();
            return;
        }
        this.traverseContext.push(node);
        try (IMNodeIterator iterator = this.store.getChildrenIterator(node);){
            while (iterator.hasNext()) {
                IMNode child = (IMNode)iterator.next();
                try {
                    this.traverse(child, idx + 1, level + 1);
                }
                finally {
                    this.store.unPin(child);
                }
            }
        }
        this.traverseContext.pop();
        if (!this.shouldTraverseTemplate) {
            return;
        }
        if (!node.isUseTemplate()) {
            return;
        }
        Template schemaTemplate = this.getActivatedSchemaTemplate(node);
        if (schemaTemplate == null) {
            return;
        }
        this.isInTemplate = true;
        this.traverseContext.push(node);
        for (IMNode childInTemplate : schemaTemplate.getDirectNodes()) {
            this.traverse(childInTemplate, idx + 1, level + 1);
        }
        this.traverseContext.pop();
        this.isInTemplate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processOneLevelWildcard(IMNode node, int idx, int level) throws MetadataException {
        IMNode child;
        boolean multiLevelWildcard = this.nodes[idx].equals("**");
        String targetNameRegex = this.nodes[idx + 1].replace("*", ".*");
        if (this.isInTemplate) {
            this.traverseContext.push(node);
            for (IMNode child2 : node.getChildren().values()) {
                if (!Pattern.matches(targetNameRegex, child2.getName())) continue;
                this.traverse(child2, idx + 1, level + 1);
            }
            this.traverseContext.pop();
            if (multiLevelWildcard) {
                this.traverseContext.push(node);
                for (IMNode child2 : node.getChildren().values()) {
                    this.traverse(child2, idx, level + 1);
                }
                this.traverseContext.pop();
            }
            return;
        }
        this.traverseContext.push(node);
        try (IMNodeIterator iterator = this.store.getChildrenIterator(node);){
            while (iterator.hasNext()) {
                child = (IMNode)iterator.next();
                try {
                    if (child.isMeasurement()) {
                        String alias = child.getAsMeasurementMNode().getAlias();
                        if (!Pattern.matches(targetNameRegex, child.getName()) && (alias == null || !Pattern.matches(targetNameRegex, alias))) continue;
                    } else if (!Pattern.matches(targetNameRegex, child.getName())) continue;
                    this.traverse(child, idx + 1, level + 1);
                }
                finally {
                    this.store.unPin(child);
                }
            }
        }
        this.traverseContext.pop();
        if (multiLevelWildcard) {
            this.traverseContext.push(node);
            iterator = this.store.getChildrenIterator(node);
            try {
                while (iterator.hasNext()) {
                    child = (IMNode)iterator.next();
                    try {
                        this.traverse(child, idx, level + 1);
                    }
                    finally {
                        this.store.unPin(child);
                    }
                }
            }
            finally {
                iterator.close();
            }
            this.traverseContext.pop();
        }
        if (!this.shouldTraverseTemplate) {
            return;
        }
        if (!node.isUseTemplate()) {
            return;
        }
        Template schemaTemplate = this.getActivatedSchemaTemplate(node);
        if (schemaTemplate == null) {
            return;
        }
        this.isInTemplate = true;
        this.traverseContext.push(node);
        for (IMNode childInTemplate : schemaTemplate.getDirectNodes()) {
            if (!Pattern.matches(targetNameRegex, childInTemplate.getName())) continue;
            this.traverse(childInTemplate, idx + 1, level + 1);
        }
        this.traverseContext.pop();
        if (multiLevelWildcard) {
            this.traverseContext.push(node);
            for (IMNode childInTemplate : schemaTemplate.getDirectNodes()) {
                this.traverse(childInTemplate, idx, level + 1);
            }
            this.traverseContext.pop();
        }
        this.isInTemplate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNameMatch(IMNode node, int idx, int level) throws MetadataException {
        boolean multiLevelWildcard = this.nodes[idx].equals("**");
        String targetName = this.nodes[idx + 1];
        if (this.isInTemplate) {
            IMNode targetNode = node.getChild(targetName);
            if (targetNode != null) {
                this.traverseContext.push(node);
                this.traverse(targetNode, idx + 1, level + 1);
                this.traverseContext.pop();
            }
            if (multiLevelWildcard) {
                this.traverseContext.push(node);
                for (IMNode child : node.getChildren().values()) {
                    this.traverse(child, idx, level + 1);
                }
                this.traverseContext.pop();
            }
            return;
        }
        IMNode next = this.store.getChild(node, targetName);
        if (next != null) {
            try {
                this.traverseContext.push(node);
                this.traverse(next, idx + 1, level + 1);
                this.traverseContext.pop();
            }
            finally {
                this.store.unPin(next);
            }
        }
        if (multiLevelWildcard) {
            this.traverseContext.push(node);
            try (IMNodeIterator iterator = this.store.getChildrenIterator(node);){
                while (iterator.hasNext()) {
                    IMNode child = (IMNode)iterator.next();
                    try {
                        this.traverse(child, idx, level + 1);
                    }
                    finally {
                        this.store.unPin(child);
                    }
                }
            }
            this.traverseContext.pop();
        }
        if (!this.shouldTraverseTemplate) {
            return;
        }
        if (!node.isUseTemplate()) {
            return;
        }
        Template schemaTemplate = this.getActivatedSchemaTemplate(node);
        if (schemaTemplate == null) {
            return;
        }
        this.isInTemplate = true;
        IMNode targetNode = schemaTemplate.getDirectNode(targetName);
        if (targetNode != null) {
            this.traverseContext.push(node);
            this.traverse(targetNode, idx + 1, level + 1);
            this.traverseContext.pop();
        }
        if (multiLevelWildcard) {
            this.traverseContext.push(node);
            for (IMNode child : schemaTemplate.getDirectNodes()) {
                this.traverse(child, idx, level + 1);
            }
            this.traverseContext.pop();
        }
        this.isInTemplate = false;
    }

    protected Template getActivatedSchemaTemplate(IMNode node) {
        if (node.getSchemaTemplateId() != -1) {
            if (this.skipPreDeletedSchema && node.getAsEntityMNode().isPreDeactivateTemplate()) {
                return null;
            }
            return this.templateMap.get(node.getSchemaTemplateId());
        }
        throw new IllegalStateException("There should not be no template mounted on any ancestor of a node usingTemplate.");
    }

    public void setTemplateMap(Map<Integer, Template> templateMap) {
        this.templateMap = templateMap;
    }

    public void setPrefixMatch(boolean isPrefixMatch) {
        this.isPrefixMatch = isPrefixMatch;
    }

    public void setShouldTraverseTemplate(boolean shouldTraverseTemplate) {
        this.shouldTraverseTemplate = shouldTraverseTemplate;
    }

    public void setSkipPreDeletedSchema(boolean skipPreDeletedSchema) {
        this.skipPreDeletedSchema = skipPreDeletedSchema;
    }

    protected PartialPath getCurrentPartialPath(IMNode currentNode) {
        return new PartialPath(this.getCurrentPathNodes(currentNode));
    }

    protected String[] getCurrentPathNodes(IMNode currentNode) {
        Iterator<IMNode> nodes = this.traverseContext.descendingIterator();
        LinkedList<String> nodeNames = new LinkedList<String>();
        if (nodes.hasNext()) {
            nodeNames.addAll(Arrays.asList(nodes.next().getPartialPath().getNodes()));
        }
        while (nodes.hasNext()) {
            nodeNames.add(nodes.next().getName());
        }
        nodeNames.add(currentNode.getName());
        return nodeNames.toArray(new String[0]);
    }

    protected IMNode getStorageGroupNodeInTraversePath(IMNode currentNode) {
        if (currentNode.isStorageGroup()) {
            return currentNode;
        }
        for (IMNode node : this.traverseContext) {
            if (!node.isStorageGroup()) continue;
            return node;
        }
        return null;
    }
}

