/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush;

import java.util.Objects;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class FlushManagerMetrics
implements IMetricSet {
    private FlushManager flushManager;

    public FlushManagerMetrics(FlushManager flushManager) {
        this.flushManager = flushManager;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.flushManager, FlushManager::getNumberOfWaitingTasks, new String[]{Tag.NAME.toString(), "flush", Tag.STATUS.toString(), "waiting"});
        metricService.createAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.flushManager, FlushManager::getNumberOfWorkingTasks, new String[]{Tag.NAME.toString(), "flush", Tag.STATUS.toString(), "running"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "flush", Tag.STATUS.toString(), "waiting"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.QUEUE.toString(), new String[]{Tag.NAME.toString(), "flush", Tag.STATUS.toString(), "running"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlushManagerMetrics that = (FlushManagerMetrics)o;
        return Objects.equals(this.flushManager, that.flushManager);
    }

    public int hashCode() {
        return Objects.hash(this.flushManager);
    }
}

