/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.compaction.cross.utils.ChunkMetadataElement;
import org.apache.iotdb.db.engine.compaction.cross.utils.FileElement;
import org.apache.iotdb.db.engine.compaction.cross.utils.PageElement;
import org.apache.iotdb.db.engine.compaction.cross.utils.SeriesCompactionExecutor;
import org.apache.iotdb.db.engine.compaction.task.SubCompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class NonAlignedSeriesCompactionExecutor
extends SeriesCompactionExecutor {
    private boolean hasStartMeasurement = false;
    private Map<TsFileResource, Pair<Long, Long>> timeseriesMetadataOffsetMap;
    private final List<TsFileResource> sortResources;

    public NonAlignedSeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<TsFileResource, List<Modification>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, String deviceId, int subTaskId, SubCompactionTaskSummary summary) {
        super(compactionWriter, readerCacheMap, modificationCacheMap, deviceId, subTaskId, summary);
        this.sortResources = sortedSourceFiles;
    }

    @Override
    public void execute() throws PageException, IllegalPathException, IOException, WriteProcessException {
        this.compactFiles();
        if (this.hasStartMeasurement) {
            this.compactionWriter.endMeasurement(this.subTaskId);
        }
    }

    public void setNewMeasurement(Map<TsFileResource, Pair<Long, Long>> timeseriesMetadataOffsetMap) {
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.sortResources.forEach(x -> this.fileList.add(new FileElement((TsFileResource)x)));
        this.hasStartMeasurement = false;
    }

    @Override
    protected void compactFiles() throws PageException, IOException, WriteProcessException, IllegalPathException {
        while (!this.fileList.isEmpty()) {
            List<FileElement> overlappedFiles = this.findOverlapFiles((FileElement)this.fileList.get(0));
            this.deserializeFileIntoQueue(overlappedFiles);
            this.compactChunks();
        }
    }

    @Override
    void deserializeFileIntoQueue(List<FileElement> fileElements) throws IOException, IllegalPathException {
        for (FileElement fileElement : fileElements) {
            TsFileResource resource = fileElement.resource;
            Pair<Long, Long> timeseriesMetadataOffset = this.timeseriesMetadataOffsetMap.get(resource);
            if (timeseriesMetadataOffset == null) {
                this.removeFile(fileElement);
                continue;
            }
            List iChunkMetadataList = ((TsFileSequenceReader)this.readerCacheMap.get(resource)).getChunkMetadataListByTimeseriesMetadataOffset(((Long)timeseriesMetadataOffset.left).longValue(), ((Long)timeseriesMetadataOffset.right).longValue());
            if (iChunkMetadataList.size() > 0) {
                QueryUtils.modifyChunkMetaData(iChunkMetadataList, this.getModificationsFromCache(resource, new PartialPath(this.deviceId, ((IChunkMetadata)iChunkMetadataList.get(0)).getMeasurementUid())));
                if (iChunkMetadataList.size() == 0) {
                    this.removeFile(fileElement);
                }
            }
            for (int i = 0; i < iChunkMetadataList.size(); ++i) {
                IChunkMetadata chunkMetadata = (IChunkMetadata)iChunkMetadataList.get(i);
                this.chunkMetadataQueue.add(new ChunkMetadataElement(chunkMetadata, resource.getVersion(), i == iChunkMetadataList.size() - 1, fileElement));
            }
        }
    }

    @Override
    void deserializeChunkIntoQueue(ChunkMetadataElement chunkMetadataElement) throws IOException {
        Chunk chunk = chunkMetadataElement.chunk;
        ChunkReader chunkReader = new ChunkReader(chunk);
        ByteBuffer chunkDataBuffer = chunk.getData();
        ChunkHeader chunkHeader = chunk.getHeader();
        while (chunkDataBuffer.remaining() > 0) {
            PageHeader pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)chunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
            ByteBuffer compressedPageData = chunkReader.readPageDataWithoutUncompressing(pageHeader);
            boolean isLastPage = chunkDataBuffer.remaining() <= 0;
            this.pageQueue.add(new PageElement(pageHeader, compressedPageData, chunkReader, chunkMetadataElement, isLastPage, chunkMetadataElement.priority));
        }
        chunkMetadataElement.clearChunks();
    }

    @Override
    void readChunk(ChunkMetadataElement chunkMetadataElement) throws IOException {
        chunkMetadataElement.chunk = ((TsFileSequenceReader)this.readerCacheMap.get(chunkMetadataElement.fileElement.resource)).readMemChunk((ChunkMetadata)chunkMetadataElement.chunkMetadata);
        if (!this.hasStartMeasurement) {
            ChunkHeader header = chunkMetadataElement.chunk.getHeader();
            MeasurementSchema schema = new MeasurementSchema(header.getMeasurementID(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
            this.compactionWriter.startMeasurement(Collections.singletonList(schema), this.subTaskId);
            this.hasStartMeasurement = true;
        }
    }

    @Override
    protected SeriesCompactionExecutor.ModifiedStatus isPageModified(PageElement pageElement) {
        long startTime = pageElement.startTime;
        long endTime = pageElement.pageHeader.getEndTime();
        return this.checkIsModified(startTime, endTime, pageElement.chunkMetadataElement.chunkMetadata.getDeleteIntervalList());
    }
}

